# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MediaLiveEventIncomingStreamReceivedEventData(Model):
    """Encoder connect event data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar ingest_url: Gets the ingest URL provided by the live event.
    :vartype ingest_url: str
    :ivar track_type: Gets the type of the track (Audio / Video).
    :vartype track_type: str
    :ivar track_name: Gets the track name.
    :vartype track_name: str
    :ivar bitrate: Gets the bitrate of the track.
    :vartype bitrate: long
    :ivar encoder_ip: Gets the remote IP.
    :vartype encoder_ip: str
    :ivar encoder_port: Gets the remote port.
    :vartype encoder_port: str
    :ivar timestamp: Gets the first timestamp of the data chunk received.
    :vartype timestamp: str
    :ivar duration: Gets the duration of the first data chunk.
    :vartype duration: str
    :ivar timescale: Gets the timescale in which timestamp is represented.
    :vartype timescale: str
    """

    _validation = {
        'ingest_url': {'readonly': True},
        'track_type': {'readonly': True},
        'track_name': {'readonly': True},
        'bitrate': {'readonly': True},
        'encoder_ip': {'readonly': True},
        'encoder_port': {'readonly': True},
        'timestamp': {'readonly': True},
        'duration': {'readonly': True},
        'timescale': {'readonly': True},
    }

    _attribute_map = {
        'ingest_url': {'key': 'ingestUrl', 'type': 'str'},
        'track_type': {'key': 'trackType', 'type': 'str'},
        'track_name': {'key': 'trackName', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'long'},
        'encoder_ip': {'key': 'encoderIp', 'type': 'str'},
        'encoder_port': {'key': 'encoderPort', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'str'},
        'timescale': {'key': 'timescale', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MediaLiveEventIncomingStreamReceivedEventData, self).__init__(**kwargs)
        self.ingest_url = None
        self.track_type = None
        self.track_name = None
        self.bitrate = None
        self.encoder_ip = None
        self.encoder_port = None
        self.timestamp = None
        self.duration = None
        self.timescale = None
