# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EdifactProtocolSettings(Model):
    """The Edifact agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :param validation_settings: Required. The EDIFACT validation settings.
    :type validation_settings:
     ~azure.mgmt.logic.models.EdifactValidationSettings
    :param framing_settings: Required. The EDIFACT framing settings.
    :type framing_settings: ~azure.mgmt.logic.models.EdifactFramingSettings
    :param envelope_settings: Required. The EDIFACT envelope settings.
    :type envelope_settings: ~azure.mgmt.logic.models.EdifactEnvelopeSettings
    :param acknowledgement_settings: Required. The EDIFACT acknowledgement
     settings.
    :type acknowledgement_settings:
     ~azure.mgmt.logic.models.EdifactAcknowledgementSettings
    :param message_filter: Required. The EDIFACT message filter.
    :type message_filter: ~azure.mgmt.logic.models.EdifactMessageFilter
    :param processing_settings: Required. The EDIFACT processing Settings.
    :type processing_settings:
     ~azure.mgmt.logic.models.EdifactProcessingSettings
    :param envelope_overrides: The EDIFACT envelope override settings.
    :type envelope_overrides:
     list[~azure.mgmt.logic.models.EdifactEnvelopeOverride]
    :param message_filter_list: The EDIFACT message filter list.
    :type message_filter_list:
     list[~azure.mgmt.logic.models.EdifactMessageIdentifier]
    :param schema_references: Required. The EDIFACT schema references.
    :type schema_references:
     list[~azure.mgmt.logic.models.EdifactSchemaReference]
    :param validation_overrides: The EDIFACT validation override settings.
    :type validation_overrides:
     list[~azure.mgmt.logic.models.EdifactValidationOverride]
    :param edifact_delimiter_overrides: The EDIFACT delimiter override
     settings.
    :type edifact_delimiter_overrides:
     list[~azure.mgmt.logic.models.EdifactDelimiterOverride]
    """

    _validation = {
        'validation_settings': {'required': True},
        'framing_settings': {'required': True},
        'envelope_settings': {'required': True},
        'acknowledgement_settings': {'required': True},
        'message_filter': {'required': True},
        'processing_settings': {'required': True},
        'schema_references': {'required': True},
    }

    _attribute_map = {
        'validation_settings': {'key': 'validationSettings', 'type': 'EdifactValidationSettings'},
        'framing_settings': {'key': 'framingSettings', 'type': 'EdifactFramingSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'EdifactEnvelopeSettings'},
        'acknowledgement_settings': {'key': 'acknowledgementSettings', 'type': 'EdifactAcknowledgementSettings'},
        'message_filter': {'key': 'messageFilter', 'type': 'EdifactMessageFilter'},
        'processing_settings': {'key': 'processingSettings', 'type': 'EdifactProcessingSettings'},
        'envelope_overrides': {'key': 'envelopeOverrides', 'type': '[EdifactEnvelopeOverride]'},
        'message_filter_list': {'key': 'messageFilterList', 'type': '[EdifactMessageIdentifier]'},
        'schema_references': {'key': 'schemaReferences', 'type': '[EdifactSchemaReference]'},
        'validation_overrides': {'key': 'validationOverrides', 'type': '[EdifactValidationOverride]'},
        'edifact_delimiter_overrides': {'key': 'edifactDelimiterOverrides', 'type': '[EdifactDelimiterOverride]'},
    }

    def __init__(self, *, validation_settings, framing_settings, envelope_settings, acknowledgement_settings, message_filter, processing_settings, schema_references, envelope_overrides=None, message_filter_list=None, validation_overrides=None, edifact_delimiter_overrides=None, **kwargs) -> None:
        super(EdifactProtocolSettings, self).__init__(**kwargs)
        self.validation_settings = validation_settings
        self.framing_settings = framing_settings
        self.envelope_settings = envelope_settings
        self.acknowledgement_settings = acknowledgement_settings
        self.message_filter = message_filter
        self.processing_settings = processing_settings
        self.envelope_overrides = envelope_overrides
        self.message_filter_list = message_filter_list
        self.schema_references = schema_references
        self.validation_overrides = validation_overrides
        self.edifact_delimiter_overrides = edifact_delimiter_overrides
