# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload

from ....aio._async_polling import AsyncDocumentTranslationLROPoller, AsyncDocumentTranslationLROPollingMethod
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ...operations._operations import (
    build_document_translation_cancel_translation_request,
    build_document_translation_get_document_status_request,
    build_document_translation_get_documents_status_request,
    build_document_translation_get_supported_document_formats_request,
    build_document_translation_get_supported_glossary_formats_request,
    build_document_translation_get_supported_storage_sources_request,
    build_document_translation_get_translation_status_request,
    build_document_translation_get_translations_status_request,
    build_document_translation_start_translation_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DocumentTranslationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.ai.translation.document.aio.BatchDocumentTranslationClient`'s
        :attr:`document_translation` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    async def _start_translation_initial(  # pylint: disable=inconsistent-return-statements
        self, body: Union[_models.StartTranslationDetails, IO], **kwargs: Any
    ) -> None:
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "StartTranslationDetails")

        request = build_document_translation_start_translation_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @overload
    async def begin_start_translation(
        self, body: _models.StartTranslationDetails, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncDocumentTranslationLROPoller[None]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document Translation service.
        Each request can contain multiple documents and must contain a source and destination container
        for each document.

        The prefix and suffix filter (if supplied) are used to filter folders. The prefix is applied to
        the subpath after the container name.

        Glossaries / Translation memory can be included in the request and are applied by the service
        when the document is translated.

        If the glossary is invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the destination, it will be overwritten. The
        targetUrl for each target language must be unique.

        :param body: request details. Required.
        :type body: ~azure.ai.translation.document.models.StartTranslationDetails
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be
         AsyncDocumentTranslationLROPollingMethod. Pass in False for this operation to not poll, or pass
         in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncDocumentTranslationLROPoller that returns None
        :rtype: ~....aio._async_polling.AsyncDocumentTranslationLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_start_translation(
        self, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncDocumentTranslationLROPoller[None]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document Translation service.
        Each request can contain multiple documents and must contain a source and destination container
        for each document.

        The prefix and suffix filter (if supplied) are used to filter folders. The prefix is applied to
        the subpath after the container name.

        Glossaries / Translation memory can be included in the request and are applied by the service
        when the document is translated.

        If the glossary is invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the destination, it will be overwritten. The
        targetUrl for each target language must be unique.

        :param body: request details. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be
         AsyncDocumentTranslationLROPollingMethod. Pass in False for this operation to not poll, or pass
         in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncDocumentTranslationLROPoller that returns None
        :rtype: ~....aio._async_polling.AsyncDocumentTranslationLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_start_translation(
        self, body: Union[_models.StartTranslationDetails, IO], **kwargs: Any
    ) -> AsyncDocumentTranslationLROPoller[None]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document Translation service.
        Each request can contain multiple documents and must contain a source and destination container
        for each document.

        The prefix and suffix filter (if supplied) are used to filter folders. The prefix is applied to
        the subpath after the container name.

        Glossaries / Translation memory can be included in the request and are applied by the service
        when the document is translated.

        If the glossary is invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the destination, it will be overwritten. The
        targetUrl for each target language must be unique.

        :param body: request details. Is either a model type or a IO type. Required.
        :type body: ~azure.ai.translation.document.models.StartTranslationDetails or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be
         AsyncDocumentTranslationLROPollingMethod. Pass in False for this operation to not poll, or pass
         in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncDocumentTranslationLROPoller that returns None
        :rtype: ~....aio._async_polling.AsyncDocumentTranslationLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._start_translation_initial(  # type: ignore
                body=body, content_type=content_type, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncDocumentTranslationLROPollingMethod(
                    lro_delay,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncDocumentTranslationLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncDocumentTranslationLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def get_translations_status(
        self,
        *,
        top: Optional[int] = None,
        skip: int = 0,
        ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        created_date_time_utc_start: Optional[datetime.datetime] = None,
        created_date_time_utc_end: Optional[datetime.datetime] = None,
        order_by: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.TranslationStatus"]:
        """Returns a list of batch requests submitted and the status for each request.

        Returns a list of batch requests submitted and the status for each request.
        This list only contains batch requests submitted by the user (based on the resource).

        If the number of requests exceeds our paging limit, server-side paging is used. Paginated
        responses indicate a partial result and include a continuation token in the response.
        The absence of a continuation token means that no additional pages are available.

        $top, $skip and $maxpagesize query parameters can be used to specify a number of results to
        return and an offset for the collection.

        $top indicates the total number of records the user wants to be returned across all pages.
        $skip indicates the number of records to skip from the list of batches based on the sorting
        method specified.  By default, we sort by descending start time.
        $maxpagesize is the maximum items returned in a page.  If more items are requested via $top (or
        $top is not specified and there are more items to be returned), @nextLink will contain the link
        to the next page.

        $orderBy query parameter can be used to sort the returned list (ex "$orderBy=createdDateTimeUtc
        asc" or "$orderBy=createdDateTimeUtc desc").
        The default sorting is descending by createdDateTimeUtc.
        Some query parameters can be used to filter the returned list (ex:
        "status=Succeeded,Cancelled") will only return succeeded and cancelled operations.
        createdDateTimeUtcStart and createdDateTimeUtcEnd can be used combined or separately to specify
        a range of datetime to filter the returned list by.
        The supported filtering query parameters are (status, ids, createdDateTimeUtcStart,
        createdDateTimeUtcEnd).

        The server honors the values specified by the client. However, clients must be prepared to
        handle responses that contain a different page size or contain a continuation token.

        When both $top and $skip are included, the server should first apply $skip and then $top on the
        collection.
        Note: If the server can't honor $top and/or $skip, the server must return an error to the
        client informing about it instead of just ignoring the query options.
        This reduces the risk of the client making assumptions about the data returned.

        :keyword top: $top indicates the total number of records the user wants to be returned across
         all pages.

         Clients MAY use $top and $skip query parameters to specify a number of results to return and
         an offset into the collection.
         When both $top and $skip are given by a client, the server SHOULD first apply $skip and then
         $top on the collection.

         Note: If the server can't honor $top and/or $skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options. Default value is None.
        :paramtype top: int
        :keyword skip: $skip indicates the number of records to skip from the list of records held by
         the server based on the sorting method specified.  By default, we sort by descending start
         time.

         Clients MAY use $top and $skip query parameters to specify a number of results to return and
         an offset into the collection.
         When both $top and $skip are given by a client, the server SHOULD first apply $skip and then
         $top on the collection.

         Note: If the server can't honor $top and/or $skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options. Default value is 0.
        :paramtype skip: int
        :keyword ids: Ids to use in filtering. Default value is None.
        :paramtype ids: list[str]
        :keyword statuses: Statuses to use in filtering. Default value is None.
        :paramtype statuses: list[str]
        :keyword created_date_time_utc_start: the start datetime to get items after. Default value is
         None.
        :paramtype created_date_time_utc_start: ~datetime.datetime
        :keyword created_date_time_utc_end: the end datetime to get items before. Default value is
         None.
        :paramtype created_date_time_utc_end: ~datetime.datetime
        :keyword order_by: the sorting query for the collection (ex: 'CreatedDateTimeUtc asc',
         'CreatedDateTimeUtc desc'). Default value is None.
        :paramtype order_by: list[str]
        :return: An iterator like instance of TranslationStatus
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.translation.document.models.TranslationStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.TranslationsStatus] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_document_translation_get_translations_status_request(
                    top=top,
                    skip=skip,
                    ids=ids,
                    statuses=statuses,
                    created_date_time_utc_start=created_date_time_utc_start,
                    created_date_time_utc_end=created_date_time_utc_end,
                    order_by=order_by,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                request = HttpRequest("GET", next_link)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.TranslationsStatus, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_document_status(self, id: str, document_id: str, **kwargs: Any) -> _models.DocumentStatus:
        """Returns the status for a specific document.

        Returns the translation status for a specific document based on the request Id and document Id.

        :param id: Format - uuid.  The batch id. Required.
        :type id: str
        :param document_id: Format - uuid.  The document id. Required.
        :type document_id: str
        :return: DocumentStatus
        :rtype: ~azure.ai.translation.document.models.DocumentStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            404: lambda response: ResourceNotFoundError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DocumentStatus] = kwargs.pop("cls", None)

        request = build_document_translation_get_document_status_request(
            id=id,
            document_id=document_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("DocumentStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def get_translation_status(self, id: str, **kwargs: Any) -> _models.TranslationStatus:
        """Returns the status for a document translation request.

        Returns the status for a document translation request.
        The status includes the overall request status, as well as the status for documents that are
        being translated as part of that request.

        :param id: Format - uuid.  The operation id. Required.
        :type id: str
        :return: TranslationStatus
        :rtype: ~azure.ai.translation.document.models.TranslationStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            404: lambda response: ResourceNotFoundError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TranslationStatus] = kwargs.pop("cls", None)

        request = build_document_translation_get_translation_status_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("TranslationStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def cancel_translation(self, id: str, **kwargs: Any) -> _models.TranslationStatus:
        """Cancel a currently processing or queued translation.

        Cancel a currently processing or queued translation.
        Cancel a currently processing or queued translation.
        A translation will not be cancelled if it is already completed or failed or cancelling. A bad
        request will be returned.
        All documents that have completed translation will not be cancelled and will be charged.
        All pending documents will be cancelled if possible.

        :param id: Format - uuid.  The operation-id. Required.
        :type id: str
        :return: TranslationStatus
        :rtype: ~azure.ai.translation.document.models.TranslationStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            404: lambda response: ResourceNotFoundError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TranslationStatus] = kwargs.pop("cls", None)

        request = build_document_translation_cancel_translation_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("TranslationStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def get_documents_status(
        self,
        id: str,
        *,
        top: Optional[int] = None,
        skip: int = 0,
        ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        created_date_time_utc_start: Optional[datetime.datetime] = None,
        created_date_time_utc_end: Optional[datetime.datetime] = None,
        order_by: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DocumentStatus"]:
        """Returns the status for all documents in a batch document translation request.

        Returns the status for all documents in a batch document translation request.

        If the number of documents in the response exceeds our paging limit, server-side paging is
        used.
        Paginated responses indicate a partial result and include a continuation token in the response.
        The absence of a continuation token means that no additional pages are available.

        $top, $skip and $maxpagesize query parameters can be used to specify a number of results to
        return and an offset for the collection.

        $top indicates the total number of records the user wants to be returned across all pages.
        $skip indicates the number of records to skip from the list of document status held by the
        server based on the sorting method specified.  By default, we sort by descending start time.
        $maxpagesize is the maximum items returned in a page.  If more items are requested via $top (or
        $top is not specified and there are more items to be returned), @nextLink will contain the link
        to the next page.

        $orderBy query parameter can be used to sort the returned list (ex "$orderBy=createdDateTimeUtc
        asc" or "$orderBy=createdDateTimeUtc desc").
        The default sorting is descending by createdDateTimeUtc.
        Some query parameters can be used to filter the returned list (ex:
        "status=Succeeded,Cancelled") will only return succeeded and cancelled documents.
        createdDateTimeUtcStart and createdDateTimeUtcEnd can be used combined or separately to specify
        a range of datetime to filter the returned list by.
        The supported filtering query parameters are (status, ids, createdDateTimeUtcStart,
        createdDateTimeUtcEnd).

        When both $top and $skip are included, the server should first apply $skip and then $top on the
        collection.
        Note: If the server can't honor $top and/or $skip, the server must return an error to the
        client informing about it instead of just ignoring the query options.
        This reduces the risk of the client making assumptions about the data returned.

        :param id: Format - uuid.  The operation id. Required.
        :type id: str
        :keyword top: $top indicates the total number of records the user wants to be returned across
         all pages.

         Clients MAY use $top and $skip query parameters to specify a number of results to return and
         an offset into the collection.
         When both $top and $skip are given by a client, the server SHOULD first apply $skip and then
         $top on the collection.

         Note: If the server can't honor $top and/or $skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options. Default value is None.
        :paramtype top: int
        :keyword skip: $skip indicates the number of records to skip from the list of records held by
         the server based on the sorting method specified.  By default, we sort by descending start
         time.

         Clients MAY use $top and $skip query parameters to specify a number of results to return and
         an offset into the collection.
         When both $top and $skip are given by a client, the server SHOULD first apply $skip and then
         $top on the collection.

         Note: If the server can't honor $top and/or $skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options. Default value is 0.
        :paramtype skip: int
        :keyword ids: Ids to use in filtering. Default value is None.
        :paramtype ids: list[str]
        :keyword statuses: Statuses to use in filtering. Default value is None.
        :paramtype statuses: list[str]
        :keyword created_date_time_utc_start: the start datetime to get items after. Default value is
         None.
        :paramtype created_date_time_utc_start: ~datetime.datetime
        :keyword created_date_time_utc_end: the end datetime to get items before. Default value is
         None.
        :paramtype created_date_time_utc_end: ~datetime.datetime
        :keyword order_by: the sorting query for the collection (ex: 'CreatedDateTimeUtc asc',
         'CreatedDateTimeUtc desc'). Default value is None.
        :paramtype order_by: list[str]
        :return: An iterator like instance of DocumentStatus
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.translation.document.models.DocumentStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.DocumentsStatus] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        error_map = {
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            404: lambda response: ResourceNotFoundError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_document_translation_get_documents_status_request(
                    id=id,
                    top=top,
                    skip=skip,
                    ids=ids,
                    statuses=statuses,
                    created_date_time_utc_start=created_date_time_utc_start,
                    created_date_time_utc_end=created_date_time_utc_end,
                    order_by=order_by,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                request = HttpRequest("GET", next_link)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.DocumentsStatus, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_supported_document_formats(self, **kwargs: Any) -> _models.SupportedFileFormats:
        """Returns a list of supported document formats.

        The list of supported document formats supported by the Document Translation service.
        The list includes the common file extension, as well as the content-type if using the upload
        API.

        :return: SupportedFileFormats
        :rtype: ~azure.ai.translation.document.models.SupportedFileFormats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SupportedFileFormats] = kwargs.pop("cls", None)

        request = build_document_translation_get_supported_document_formats_request(
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = self._deserialize("SupportedFileFormats", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def get_supported_glossary_formats(self, **kwargs: Any) -> _models.SupportedFileFormats:
        """Returns the list of supported glossary formats.

        The list of supported glossary formats supported by the Document Translation service.
        The list includes the common file extension used.

        :return: SupportedFileFormats
        :rtype: ~azure.ai.translation.document.models.SupportedFileFormats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SupportedFileFormats] = kwargs.pop("cls", None)

        request = build_document_translation_get_supported_glossary_formats_request(
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = self._deserialize("SupportedFileFormats", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def get_supported_storage_sources(self, **kwargs: Any) -> _models.SupportedStorageSources:
        """Returns a list of supported storage sources.

        Returns a list of storage sources/options supported by the Document Translation service.

        :return: SupportedStorageSources
        :rtype: ~azure.ai.translation.document.models.SupportedStorageSources
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            500: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.TranslationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SupportedStorageSources] = kwargs.pop("cls", None)

        request = build_document_translation_get_supported_storage_sources_request(
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = self._deserialize("SupportedStorageSources", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
