# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementUserOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_user_list_by_service(self, resource_group):
        response = self.client.user.list_by_service(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_user_get_entity_tag(self, resource_group):
        response = self.client.user.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            user_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_user_get(self, resource_group):
        response = self.client.user.get(
            resource_group_name=resource_group.name,
            service_name="str",
            user_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_user_create_or_update(self, resource_group):
        response = self.client.user.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            user_id="str",
            parameters={
                "appType": "str",
                "confirmation": "str",
                "email": "str",
                "firstName": "str",
                "identities": [{"id": "str", "provider": "str"}],
                "lastName": "str",
                "note": "str",
                "password": "str",
                "state": "active",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_user_update(self, resource_group):
        response = self.client.user.update(
            resource_group_name=resource_group.name,
            service_name="str",
            user_id="str",
            if_match="str",
            parameters={
                "email": "str",
                "firstName": "str",
                "identities": [{"id": "str", "provider": "str"}],
                "lastName": "str",
                "note": "str",
                "password": "str",
                "state": "active",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_user_begin_delete(self, resource_group):
        response = self.client.user.begin_delete(
            resource_group_name=resource_group.name,
            service_name="str",
            user_id="str",
            if_match="str",
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_user_generate_sso_url(self, resource_group):
        response = self.client.user.generate_sso_url(
            resource_group_name=resource_group.name,
            service_name="str",
            user_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_user_get_shared_access_token(self, resource_group):
        response = self.client.user.get_shared_access_token(
            resource_group_name=resource_group.name,
            service_name="str",
            user_id="str",
            parameters={"expiry": "2020-02-20 00:00:00", "keyType": "str"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
