# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid.aio import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementChannelsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_channels_get(self, resource_group):
        response = await self.client.channels.get(
            resource_group_name=resource_group.name,
            partner_namespace_name="str",
            channel_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_channels_create_or_update(self, resource_group):
        response = await self.client.channels.create_or_update(
            resource_group_name=resource_group.name,
            partner_namespace_name="str",
            channel_name="str",
            channel_info={
                "channelType": "str",
                "expirationTimeIfNotActivatedUtc": "2020-02-20 00:00:00",
                "id": "str",
                "messageForActivation": "str",
                "name": "str",
                "partnerDestinationInfo": "partner_destination_info",
                "partnerTopicInfo": {
                    "azureSubscriptionId": "str",
                    "eventTypeInfo": {
                        "inlineEventTypes": {
                            "str": {
                                "dataSchemaUrl": "str",
                                "description": "str",
                                "displayName": "str",
                                "documentationUrl": "str",
                            }
                        },
                        "kind": "str",
                    },
                    "name": "str",
                    "resourceGroupName": "str",
                    "source": "str",
                },
                "provisioningState": "str",
                "readinessState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_channels_begin_delete(self, resource_group):
        response = await (
            await self.client.channels.begin_delete(
                resource_group_name=resource_group.name,
                partner_namespace_name="str",
                channel_name="str",
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_channels_update(self, resource_group):
        response = await self.client.channels.update(
            resource_group_name=resource_group.name,
            partner_namespace_name="str",
            channel_name="str",
            channel_update_parameters={
                "expirationTimeIfNotActivatedUtc": "2020-02-20 00:00:00",
                "partnerDestinationInfo": "partner_update_destination_info",
                "partnerTopicInfo": {
                    "eventTypeInfo": {
                        "inlineEventTypes": {
                            "str": {
                                "dataSchemaUrl": "str",
                                "description": "str",
                                "displayName": "str",
                                "documentationUrl": "str",
                            }
                        },
                        "kind": "str",
                    }
                },
            },
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_channels_list_by_partner_namespace(self, resource_group):
        response = self.client.channels.list_by_partner_namespace(
            resource_group_name=resource_group.name,
            partner_namespace_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_channels_get_full_url(self, resource_group):
        response = await self.client.channels.get_full_url(
            resource_group_name=resource_group.name,
            partner_namespace_name="str",
            channel_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...
