/***************************************************************************
 *   Copyright (C) 2007-2014 by Vegeta                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QTGAIN_H
#define QTGAIN_H

#include <QtWidgets>
#include "Core.h"


class CoverDownload;
class renameFiles;
class QProcess;
class QUrl;


namespace Ui {
class QtGainClass;
}

class QtGain : public QMainWindow, private Core
{
    Q_OBJECT

public:
    QtGain(QWidget *parent = 0, Qt::WindowFlags flags = 0);
    ~QtGain();

private:
    Ui::QtGainClass *ui;

    renameFiles *RenameFiles;

    bool isForceRecalulation;
    QTimer   *Timer;
    QProcess *TrackGainProcess;
    QProcess *AlbumGainProcess;
    QProcess *FlacAlbumGainProcess;
    QAction  *actionAbout;
    QAction  *actionCancelOperation;
    QAction  *actionShowSettings;
    QAction  *actionQuit;
    QString m_Errorlog;
    QString m_lastAlbumGainOutput;
    bool    m_lastFileSkipped;            // New code for skipping FLAC files

    void startupInitiations();
    void processOutput();
    void findFiles(const QString &dirName);
    void processRawFileList(QList<QUrl> &urls);
    void openDirectoryDialog();
    void processFoundFiles();
    void loadSettings();
    void saveSettings();
    void showErrors();
    QString ErrorLog() const {return m_Errorlog;}
    void resetErrorlog(){m_Errorlog.clear();}
    void processFiles_AlbumGain();
    void openDialog(QString Text);


private slots:
    void processFiles_TrackGain();
    void setGUI_To(int const &Status = RESET_ALL, QString Message = "");
    void processOutput_AlbumGain();
    void showPreferencesDialog();
    void showAboutDialog();

    void updateGUIInfos(QString Statustext,
                        QString Foldertext,
                        QString Filetext,
                        int ToDo,
                        int Error,
                        int Skipped,
                        int Gained,
                        int progressBarValue,
                        int progressBarMax,
                        bool setDownloadIcon);
    void addToErrorlog(const QString &Error) {m_Errorlog.append(Error);}

protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dropEvent(QDropEvent *event);
    void closeEvent(QCloseEvent *event);
};

#endif // QTGAIN_H
