% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotationFilterList.R
\docType{methods}
\name{AnnotationFilterList}
\alias{AnnotationFilterList}
\alias{AnnotationFilterList-class}
\alias{AnnotationFilterList}
\alias{value,AnnotationFilterList-method}
\alias{logicOp,AnnotationFilterList-method}
\alias{logicOp}
\alias{not,AnnotationFilterList-method}
\alias{not}
\alias{distributeNegation,AnnotationFilterList-method}
\alias{distributeNegation}
\alias{convertFilter,AnnotationFilterList,missing-method}
\alias{convertFilter}
\alias{show,AnnotationFilterList-method}
\title{Combining annotation filters}
\usage{
AnnotationFilterList(..., logicOp = character(), logOp = character(),
  not = FALSE, .groupingFlag = FALSE)

\S4method{value}{AnnotationFilterList}(object)

\S4method{logicOp}{AnnotationFilterList}(object)

\S4method{not}{AnnotationFilterList}(object)

\S4method{distributeNegation}{AnnotationFilterList}(object,
  .prior_negation = FALSE)

\S4method{convertFilter}{AnnotationFilterList,missing}(object)

\S4method{show}{AnnotationFilterList}(object)
}
\arguments{
\item{...}{individual \code{\link{AnnotationFilter}} objects or a
mixture of \code{AnnotationFilter} and
\code{AnnotationFilterList} objects.}

\item{logicOp}{\code{character} of length equal to the number
of submitted \code{AnnotationFilter} objects - 1. Each value
representing the logical operation to combine consecutive
filters, i.e. the first element being the logical operation to
combine the first and second \code{AnnotationFilter}, the
second element being the logical operation to combine the
second and third \code{AnnotationFilter} and so on. Allowed
values are \code{"&"} and \code{"|"}. The function assumes a
logical \emph{and} between all elements by default.}

\item{logOp}{Deprecated; use \code{logicOp=}.}

\item{not}{\code{logical} of length one. Indicates whether the grouping
of \code{AnnotationFilters} are to be negated.}

\item{.groupingFlag}{Flag desginated for internal use only.}

\item{object}{An object of class \code{AnnotationFilterList}.}

\item{.prior_negation}{\code{logical(1)} unused argument.}
}
\value{
\code{AnnotationFilterList} returns an \code{AnnotationFilterList}.

\code{value()} returns a \code{list} with \code{AnnotationFilter}
    objects.

\code{logicOp()} returns a \code{character()} vector of
    \dQuote{&} or \dQuote{|} symbols.

\code{not()} returns a \code{character()} vector of
    \dQuote{&} or \dQuote{|} symbols.

\code{AnnotationFilterList} object with DeMorgan's law applied to
     it such that it is equal to the original \code{AnnotationFilterList}
     object but all \code{!}'s are distributed out of the
     \code{AnnotationFilterList} object and to the nested
     \code{AnnotationFilter} objects.

\code{character(1)} that can be used as input to a \code{dplyr}
     filter.
}
\description{
The \code{AnnotationFilterList} allows to combine
    filter objects extending the \code{\link{AnnotationFilter}}
    class to construct more complex queries. Consecutive filter
    objects in the \code{AnnotationFilterList} can be combined by a
    logical \emph{and} (\code{&}) or \emph{or} (\code{|}). The
    \code{AnnotationFilterList} extends \code{list}, individual
    elements can thus be accessed with \code{[[}.

\code{value()} get a \code{list} with the
    \code{AnnotationFilter} objects. Use \code{[[} to access
    individual filters.

\code{logicOp()} gets the logical operators separating
    successive \code{AnnotationFilter}.

\code{not()} gets the logical operators separating
    successive \code{AnnotationFilter}.



Converts an \code{AnnotationFilterList} object to a
     \code{character(1)} giving an equation that can be used as input to
     a \code{dplyr} filter.
}
\note{
The \code{AnnotationFilterList} does not support containing empty
    elements, hence all elements of \code{length == 0} are removed in
    the constructor function.
}
\examples{
## Create some AnnotationFilters
gf <- GenenameFilter(c("BCL2", "BCL2L11"))
tbtf <- TxBiotypeFilter("protein_coding", condition = "!=")

## Combine both to an AnnotationFilterList. By default elements are combined
## using a logical "and" operator. The filter list represents thus a query
## like: get all features where the gene name is either ("BCL2" or "BCL2L11")
## and the transcript biotype is not "protein_coding".
afl <- AnnotationFilterList(gf, tbtf)
afl

## Access individual filters.
afl[[1]]

## Create a filter in the form of: get all features where the gene name is
## either ("BCL2" or "BCL2L11") and the transcript biotype is not
## "protein_coding" or the seq_name is "Y". Hence, this will get all feature
## also found by the previous AnnotationFilterList and returns also all
## features on chromosome Y.
afl <- AnnotationFilterList(gf, tbtf, SeqNameFilter("Y"),
                            logicOp = c("&", "|"))
afl

afl <- AnnotationFilter(~!(symbol == 'ADA' | symbol \%startsWith\% 'SNORD'))
afl <- distributeNegation(afl)
afl
afl <- AnnotationFilter(~symbol=="ADA" & tx_start > "400000")
result <- convertFilter(afl)
result
}
\seealso{
\code{\link{supportedFilters}} for available
    \code{\link{AnnotationFilter}} objects
}
