% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_filter.R
\name{bold_filter}
\alias{bold_filter}
\title{Get BOLD specimen + sequence data.}
\usage{
bold_filter(x, by, how = "max")
}
\arguments{
\item{x}{(data.frame) a data.frame, as returned from
\code{\link{bold_seqspec}}. Note that some combinations of parameters
in \code{\link{bold_seqspec}} don't return a data.frame. Stops with
error message if this is not a data.frame. Required.}

\item{by}{(character) the column by which to group. For example,
if you want the longest sequence for each unique species name, then
pass \strong{species_name}. If the column doesn't exist, error
with message saying so. Required.}

\item{how}{(character) one of "max" or "min", which get used as
\code{which.max} or \code{which.min} to get the longest or shortest
sequence, respectively. Note that we remove gap/alignment characters
(\code{-})}
}
\value{
a tibble/data.frame
}
\description{
Get BOLD specimen + sequence data.
}
\examples{
\dontrun{
res <- bold_seqspec(taxon='Osmia')
maxx <- bold_filter(res, by = "species_name")
minn <- bold_filter(res, by = "species_name", how = "min")

vapply(maxx$nucleotides, nchar, 1, USE.NAMES = FALSE)
vapply(minn$nucleotides, nchar, 1, USE.NAMES = FALSE)
}
}
