% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backends.R
\name{opencl}
\alias{opencl}
\title{GPU support in Stan via OpenCL}
\usage{
opencl(ids = NULL)
}
\arguments{
\item{ids}{(integer vector of length 2) The platform and device IDs of the
OpenCL device to use for fitting. If you don't know the IDs of your OpenCL
device, \code{c(0,0)} is most likely what you need.}
}
\value{
A \code{brmsopencl} object which can be passed to the
  \code{opencl} argument of \code{brm} and related functions.
}
\description{
Use OpenCL for GPU support in \pkg{Stan} via the \pkg{brms} interface. Only
some \pkg{Stan} functions can be run on a GPU at this point and so
a lot of \pkg{brms} models won't benefit from OpenCL for now.
}
\details{
For more details on OpenCL in \pkg{Stan}, check out
\url{https://mc-stan.org/docs/2_26/cmdstan-guide/parallelization.html#opencl}
as well as \url{https://mc-stan.org/docs/2_26/stan-users-guide/opencl.html}.
}
\examples{
\dontrun{
# this model just serves as an illustration
# OpenCL may not actually speed things up here
fit <- brm(count ~ zAge + zBase * Trt + (1|patient),
           data = epilepsy, family = poisson(),
           chains = 2, cores = 2, opencl = opencl(c(0, 0)),
           backend = "cmdstanr")
summary(fit)
}

}
