% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFALSE.R
\name{checkFALSE}
\alias{checkFALSE}
\alias{check_false}
\alias{assertFALSE}
\alias{assert_false}
\alias{testFALSE}
\alias{test_false}
\title{Check if an argument is FALSE}
\usage{
checkFALSE(x, na.ok = FALSE)

check_false(x, na.ok = FALSE)

assertFALSE(x, na.ok = FALSE, .var.name = vname(x), add = NULL)

assert_false(x, na.ok = FALSE, .var.name = vname(x), add = NULL)

testFALSE(x, na.ok = FALSE)

test_false(x, na.ok = FALSE)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertFALSE.}/\code{assert_false.} return 
 \code{x} invisibly, whereas
 \code{checkFALSE.}/\code{check_false.} and 
 \code{testFALSE.}/\code{test_false.} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertFALSE.}/\code{assert_false.}
 throws an error message, 
 \code{testFALSE.}/\code{test_false.}
 returns \code{FALSE},
 and \code{checkFALSE.} returns a string with the error message.
 The function \code{expect_false.} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Simply checks if an argument is \code{FALSE}.
}
\examples{
testFALSE(FALSE)
testFALSE(TRUE)
}
