% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{year-quarter-day-arithmetic}
\alias{year-quarter-day-arithmetic}
\alias{add_years.clock_year_quarter_day}
\alias{add_quarters.clock_year_quarter_day}
\title{Arithmetic: year-quarter-day}
\usage{
\method{add_years}{clock_year_quarter_day}(x, n, ...)

\method{add_quarters}{clock_year_quarter_day}(x, n, ...)
}
\arguments{
\item{x}{\verb{[clock_year_quarter_day]}

A year-quarter-day vector.}

\item{n}{\verb{[integer / clock_duration]}

An integer vector to be converted to a duration, or a duration
corresponding to the arithmetic function being used. This corresponds
to the number of duration units to add. \code{n} may be negative to subtract
units of duration.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} after performing the arithmetic.
}
\description{
These are year-quarter-day methods for the
\link[=clock-arithmetic]{arithmetic generics}.
\itemize{
\item \code{add_years()}
\item \code{add_quarters()}
}

Notably, \emph{you cannot add days to a year-quarter-day}. For day-based
arithmetic, first convert to a time point with \code{\link[=as_naive_time]{as_naive_time()}} or
\code{\link[=as_sys_time]{as_sys_time()}}.
}
\details{
\code{x} and \code{n} are recycled against each other using
\link[vctrs:vector_recycling_rules]{tidyverse recycling rules}.
}
\examples{
x <- year_quarter_day(2019, 1:3)
x

add_quarters(x, 2)

# Make the fiscal year start in March
y <- year_quarter_day(2019, 1:2, 1, start = 3)
y

add_quarters(y, 1)

# What year-month-day does this correspond to?
# Note that the fiscal year doesn't necessarily align with the Gregorian
# year!
as_year_month_day(add_quarters(y, 1))
}
