% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{emoa_control}
\alias{emoa_control}
\title{Basic EMOA control parameters.}
\usage{
emoa_control(f, upper, lower, ..., control, default)
}
\arguments{
\item{f}{Multiobjectve optimization function.}

\item{upper}{Upper bounds of parameter space.}

\item{lower}{Lower bounds of parameter space.}

\item{...}{Further arguments passed to \code{f}.}

\item{control}{List of control parameters.}

\item{default}{List of default control parameters.}
}
\value{
The \code{control} list with suitably adjusted
arguments. Missing control parameters are taken from
\code{default} or, if not present there, from an internal default.
}
\description{
The following control parameters are recognized by \code{emoa_control}:
\describe{
  \item{logger}{\code{emoa_logger} object used to log events.}
  \item{n}{Number of parameters, defaults to the length of the longer
    of \code{upper} or \code{lower}.}
  \item{d}{Number of dimensions.}
}
}
\author{
Olaf Mersmann \email{olafm@statistik.tu-dortmund.de}
}
