% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{as_flextable.htest}
\alias{as_flextable.htest}
\title{Transform a 'htest' object into a flextable}
\usage{
\method{as_flextable}{htest}(x, ...)
}
\arguments{
\item{x}{htest object}

\item{...}{unused argument}
}
\description{
produce a flextable describing an
object oof class \code{htest}.
}
\examples{
if (require("stats")) {
  M <- as.table(rbind(c(762, 327, 468), c(484, 239, 477)))
  dimnames(M) <- list(
    gender = c("F", "M"),
    party = c("Democrat", "Independent", "Republican")
  )
  ft_1 <- as_flextable(chisq.test(M))
  ft_1
}
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable}()},
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.table}()},
\code{\link{as_flextable.tabular}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()}
}
\concept{as_flextable methods}
