% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_printer.R
\name{df_printer}
\alias{df_printer}
\title{data.frame automatic printing as a flextable}
\usage{
df_printer(dat, ...)
}
\arguments{
\item{dat}{the data.frame}

\item{...}{unused argument}
}
\description{
Create a summary from a data.frame as a flextable. This function
is to be used in an R Markdown document.

To use that function, you must declare it in the part \code{df_print} of the 'YAML'
header of your R Markdown document:

\if{html}{\out{<div class="sourceCode">}}\preformatted{---
df_print: !expr function(x) flextable::df_printer(x)
---
}\if{html}{\out{</div>}}

We notice an unexpected behavior with bookdown. When using bookdown it
is necessary to use \code{\link[=use_df_printer]{use_df_printer()}} instead in a setup run chunk:

\if{html}{\out{<div class="sourceCode">}}\preformatted{use_df_printer()
}\if{html}{\out{</div>}}
}
\details{
'knitr' chunk options are available to customize the output:
\itemize{
\item \code{ft_max_row}: The number of rows to print. Default to 10.
\item \code{ft_split_colnames}: Should the column names be split
(with non alpha-numeric characters). Default to FALSE.
\item \code{ft_short_strings}: Should the character column be shorten.
Default to FALSE.
\item \code{ft_short_size}: Maximum length of character column if
\code{ft_short_strings} is TRUE. Default to 35.
\item \code{ft_short_suffix}: Suffix to add when character values are shorten.
Default to "...".
\item \code{ft_do_autofit}: Use autofit() before rendering the table.
Default to TRUE.
\item \code{ft_show_coltype}: Show column types.
Default to TRUE.
\item \code{ft_color_coltype}: Color to use for column types.
Default to "#999999".
}
}
\examples{
df_printer(head(mtcars))
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()}
}
\concept{flextable print function}
