% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revparse.R
\name{revparse_single}
\alias{revparse_single}
\title{Revparse}
\usage{
revparse_single(repo = ".", revision = NULL)
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}

\item{revision}{The revision string, see
http://git-scm.com/docs/git-rev-parse.html#_specifying_revisions}
}
\value{
a \code{git_commit} or \code{git_tag} or \code{git_tree}
object
}
\description{
Find object specified by revision.
}
\examples{
\dontrun{
## Create a directory in tempdir
path <- tempfile(pattern="git2r-")
dir.create(path)

## Initialize a repository
repo <- init(path)
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Create a file, add and commit
lines <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
writeLines(lines, file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "First commit message")

# Change file and commit
lines <- c(
  "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
  "eiusmod tempor incididunt ut labore et dolore magna aliqua.")
writeLines(lines, file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "Second commit message")

revparse_single(repo, "HEAD^")
revparse_single(repo, "HEAD:test.txt")
}
}
