% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REmargins.R
\name{REmargins}
\alias{REmargins}
\title{Calculate the predicted value for each observation across the distribution
of the random effect terms.}
\usage{
REmargins(merMod, newdata = NULL, groupFctr = NULL, term = NULL,
  breaks = 4, .parallel = FALSE, ...)
}
\arguments{
\item{merMod}{An object of class merMod}

\item{newdata}{a data frame of observations to calculate group-level differences
for}

\item{groupFctr}{The name of the grouping factor over which the random
coefficient of interest varies.  This is the variable to the right of the
pipe, \code{|}, in the [g]lmer formula. This parameter is optional, if not
specified, it will perform the calculation for the first effect listed
by \code{ranef}. If the length is > 1 then the combined effect of all
listed groups will calculated and marginalized over co-occurences of those
groups if desired.}

\item{term}{The name of the random coefficient of interest. This is the
variable to the left of the pipe, \code{|}, in the [g]lmer formula. Partial
matching is attempted on the intercept term so the following character
strings will all return rankings based on the intercept (\emph{provided that
they do not match the name of another random coefficient for that factor}):
\code{c("(Intercept)", "Int", "intercep", ...)}.}

\item{breaks}{an integer representing the number of bins to divide the group
effects into, the default is 3.}

\item{.parallel, }{logical should parallel computation be used, default is TRUE}

\item{...}{additional arguments to pass to \code{\link{predictInterval}}}
}
\value{
A data.frame with all unique combinations of the number of cases, rows
in the newdata element:
  \describe{
    \item{...}{The columns of the original data taken from \code{newdata}}
    \item{case}{The row number of the observation from newdata. Each row in newdata will be
    repeated for all unique levels of the grouping_var, term, and breaks.}
    \item{grouping_var}{The grouping variable the random effect is being marginalized over.}
    \item{term}{The term for the grouping variable the random effect is being marginalized over.}
    \item{breaks}{The ntile of the effect size for \code{grouping_var} and \code{term}}
    \item{original_group_level}{The original grouping value for this \code{case}}
    \item{fit_combined}{The predicted value from \code{predictInterval} for this case simulated
    at the Nth ntile of the expected rank distribution of \code{grouping_var} and \code{term}}
    \item{upr_combined}{The upper bound of the predicted value.}
    \item{lwr_combined}{The lower bound of the predicted value.}
    \item{fit_XX}{For each grouping term in newdata the predicted value is decomposed into its
    fit components via predictInterval and these are all returned here}
    \item{upr_XX}{The upper bound for the effect of each grouping term}
    \item{lwr_XX}{The lower bound for the effect of each grouping term}
    \item{fit_fixed}{The predicted fit with all the grouping terms set to 0 (average)}
    \item{upr_fixed}{The upper bound fit with all the grouping terms set to 0 (average)}
    \item{lwr_fixed}{The lower bound fit with all the grouping terms set to 0 (average)}
  }
}
\description{
\code{REmargins} calculates the average predicted value for each row of a
new data frame across the distribution of \code{\link{expectedRank}} for a
merMod object. This allows the user to make meaningful comparisons about the
influence of random effect terms on the scale of the response variable,
for user-defined inputs, and accounting for the variability in grouping terms.
}
\details{
The function simulates the

The function predicts the response at every level in the random effect term
specified by the user. Then, the expected rank of each group level is binned
to the number of bins specified by the user. Finally, a weighted mean of the
fitted value for all observations in each bin of the expected ranks is
calculated using the inverse of the variance as the weight -- so that less
precise estimates are downweighted in the calculation of the mean for the bin.
Finally, a standard error for the bin mean is calculated.
}
\examples{
fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
mfx <- REmargins(merMod = fm1, newdata = sleepstudy[1:10,])
\donttest{
# You can also pass additional arguments to predictInterval through REimpact
 g1 <- lmer(y ~ lectage + studage + (1|d) + (1|s), data=InstEval)
 margin_df <- REmargins(g1, newdata = InstEval[20:25, ], groupFctr = c("s"),
                        breaks = 4)
 margin_df <- REmargins(g1, newdata = InstEval[20:25, ], groupFctr = c("d"),
                         breaks = 3)
}
}
\references{
Gatz, DF and Smith, L. The Standard Error of a Weighted Mean Concentration.
I. Bootstrapping vs other methods. \emph{Atmospheric Environment}.
1995;11(2)1185-1193. Available at
\url{http://www.sciencedirect.com/science/article/pii/135223109400210C}

Cochran, WG. 1977. Sampling Techniques (3rd Edition). Wiley, New York.
}
\seealso{
\code{\link{expectedRank}}, \code{\link{predictInterval}}
}
