% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthat.R
\name{expect_known_display}
\alias{expect_known_display}
\title{Test helpers}
\usage{
expect_known_display(object, file, ..., width = 80L, crayon = TRUE)
}
\arguments{
\item{object}{An object to check.}

\item{file}{File path where known value/output will be stored.}

\item{...}{Unused.}

\item{width}{The width of the output.}

\item{crayon}{Color the output?}
}
\description{
Expectation for packages that implement a data type with pillar support.
Allows storing the desired result in a file,
and comparing the output with the file contents.
Note that this expectation sets options that affect the formatting of the
pillar, see examples for usage.
}
\examples{
file <- tempfile("pillar", fileext = ".txt")

# The pillar is constructed after options have been set
# (need two runs because reference file doesn't exist during the first run)
suppressWarnings(tryCatch(
  expect_known_display(pillar(1:3), file, crayon = FALSE),
  expectation_failure = function(e) {}
))
expect_known_display(pillar(1:3), file, crayon = FALSE)

# Good: Use tidyeval to defer construction
pillar_quo <- rlang::quo(pillar(1:3))
expect_known_display(!!pillar_quo, file, crayon = FALSE)

\dontrun{
# Bad: Options set in the active session may affect the display
integer_pillar <- pillar(1:3)
expect_known_display(integer_pillar, file, crayon = FALSE)
}
}
