% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xnumbers-docs.R
\name{pretty_num}
\alias{pretty_num}
\alias{compute_num}
\title{Linear quantities in a human readable string}
\usage{
pretty_num(number, style = c("default", "nopad", "6"))

compute_num(number, smallest_prefix = "y")
}
\arguments{
\item{number}{Numeric vector, number related to a linear quantity.}

\item{style}{Formatting style:
\itemize{
\item \code{"default"} is the original \code{pretty_num} formatting, and it always
pads the output, so that all vector elements are of the same width,
\item \code{"nopad"} is similar, but does not pad the output,
\item \code{"6"} always uses 6 characters,
The \code{"6"} style is useful if it is important that the output always
has the same width (number of characters), e.g. in progress bars.
See some examples below.
}}

\item{smallest_prefix}{A character scalar, the smallest prefix to use.}
}
\value{
Character vector, the formatted sizes.
For \code{compute_num}, a data frame with columns \code{amount}, \code{prefix},
\code{negative}.
}
\description{
Use \code{pretty_num()} to format numbers \code{compute_num()} is the underlying
engine that may be useful for custom formatting.
}
\examples{
numbers <- c(1337, 1.3333e-5, 13333337, 1333333337, 133333333337)
pretty_num(numbers)
pretty_num(numbers, style = "nopad")
pretty_num(numbers, style = "6")
}
