% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_filesize.R
\name{handler_filesize}
\alias{handler_filesize}
\title{Progression Handler: Progress Reported as the Size of a File on the File System}
\usage{
handler_filesize(
  file = "default.progress",
  intrusiveness = getOption("progressr.intrusiveness.file", 5),
  target = "file",
  ...
)
}
\arguments{
\item{file}{(character) A filename.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
Progression Handler: Progress Reported as the Size of a File on the File System
}
\details{
This progression handler reports progress by updating the size of a file
on the file system. This provides a convenient way for an R script running
in batch mode to report on the progress such that the user can peek at the
file size (by default in 0-100 bytes) to assess the amount of the progress
made, e.g. \verb{ls -l -- *.progress}.
If the \file{*.progress} file is accessible via for instance SSH, SFTP,
FTPS, HTTPS, etc., then progress can be assessed from a remote location.
}
\examples{
\donttest{\dontrun{
handlers(handler_filesize(file = "myscript.progress"))
with_progress(y <- slow_sum(1:100))
print(y)
}}

}
