% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcdk.R
\name{is.connected}
\alias{is.connected}
\title{Tests whether the molecule is fully connected.}
\usage{
is.connected(mol)
}
\arguments{
\item{mol}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}
}
\value{
`TRUE` if molecule is complete, `FALSE` otherwise
}
\description{
A single molecule will be represented as a 
\href{https://en.wikipedia.org/wiki/Complete_graph}{complete} graph. 
In some cases, such as for molecules in salt form, or after certain 
operations such as bond splits, the molecular graph may contained 
\href{http://mathworld.wolfram.com/DisconnectedGraph.html}{disconnected components}.
This method can be used to tested whether the molecule is complete (i.e. fully
connected).
}
\examples{
m <- parse.smiles("CC.CCCCCC.CCCC")[[1]]
is.connected(m)
}
\seealso{
\code{\link{get.largest.component}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
