% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{getOAuthIntegrations}
\alias{getOAuthIntegrations}
\title{Get OAuth Integrations}
\usage{
getOAuthIntegrations()
}
\value{
A list of OAuth integrations, where each element contains:
\describe{
\item{type}{The integration type (e.g., "custom").}
\item{name}{The integration name.}
\item{display_name}{The display name (may be NULL).}
\item{client_id}{The OAuth client ID.}
\item{auth_url}{The authorization URL.}
\item{token_url}{The token URL.}
\item{scopes}{A character vector of OAuth scopes.}
\item{issuer}{The OAuth issuer URL.}
\item{authenticated}{Boolean indicating if currently authenticated.}
\item{guid}{The globally unique identifier for this integration (useful for \code{getOAuthCredentials()}).}
}
Returns an empty list if no integrations are configured.
}
\description{
Retrieve a list of all OAuth integrations configured in Posit Workbench.
This returns metadata about each integration including its authentication status,
scopes, and configuration details.
}
\note{
This function requires Posit Workbench version 2026.01.0 or later. It works
in any IDE running within a Posit Workbench session (not just RStudio).
}
\examples{
\dontrun{
# Get all OAuth integrations
integrations <- getOAuthIntegrations()

# Show all integrations
for (int in integrations) {
  cat(sprintf("\%s (\%s): \%s\n",
              int$name,
              int$guid,
              if (int$authenticated) "authenticated" else "not authenticated"))
}

# Filter to authenticated integrations only
authenticated <- Filter(function(x) x$authenticated, integrations)

# Get credentials for the first authenticated integration
if (length(authenticated) > 0) {
  creds <- getOAuthCredentials(audience = authenticated[[1]]$guid)
}
}
}
