% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logmap.R
\name{[,LogMap}
\alias{[,LogMap}
\alias{[,LogMap,missing,missing,ANY-method}
\alias{[,LogMap,character,character,ANY-method}
\alias{[,LogMap,character,missing,ANY-method}
\alias{[,LogMap,missing,character,ANY-method}
\alias{[,LogMap,numeric,missing,ANY-method}
\alias{[,LogMap,missing,numeric,ANY-method}
\alias{[,LogMap,numeric,numeric,ANY-method}
\title{Matrix-like Subsetting for \link[=LogMap]{Logical Maps}}
\usage{
\S4method{[}{LogMap,missing,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{LogMap,character,character,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{LogMap,character,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{LogMap,missing,character,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{LogMap,numeric,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{LogMap,missing,numeric,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{LogMap,numeric,numeric,ANY}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \code{LogMap} object}

\item{i, j}{Vectors of values (\code{i}) and observations (\code{j}) to pull
from \code{x}}

\item{...}{Arguments passed to other methods}

\item{drop}{relevant for matrices and arrays.  If \code{TRUE} the result is
    coerced to the lowest possible dimension (see the examples).  This
    only works for extracting elements, not for the replacement.  See
    \code{\link[base]{drop}} for further details.
  }
}
\description{
Matrix-like Subsetting for \link[=LogMap]{Logical Maps}
}
\note{
\code{i} is not reordable; passing a different order for \code{i}
will return a subset with rows in the same order as \code{x}
}
\examples{
map <- LogMap(letters[1:10])
map[['obs']] <- c(1, 3, 7)
map[['entry']] <- c(2, 7, 10)

map[]
map[1:5, 2L]
map[c("b", "c", "f"), "obs"]

# Pass `drop = TRUE` to cast to `matrix`
map[1:3, , drop = TRUE]

# Note that `i` is non-reordable
rownames(map)[1:3]
map[c("b", "c", "a"), , drop = TRUE]

}
\keyword{internal}
