% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_sd.R
\name{sparse_sd}
\alias{sparse_sd}
\title{Calculate standard diviation from sparse vectors}
\usage{
sparse_sd(x, na_rm = FALSE)
}
\arguments{
\item{x}{A sparse numeric vector.}

\item{na_rm}{Logical, whether to remove missing values. Defaults to \code{FALSE}.}
}
\value{
single numeric value.
}
\description{
Calculate standard diviation from sparse vectors
}
\details{
This function, as with any of the other helper functions assumes that the
input \code{x} is a sparse numeric vector. This is done for performance reasons,
and it is thus the users responsibility to perform input checking.

Much like \code{\link[=sd]{sd()}} it uses the denominator \code{n-1}.
}
\examples{
sparse_sd(
  sparse_double(1000, 1, 1000)
)

sparse_sd(
  sparse_double(1000, 1, 1000, default = 1)
)

sparse_sd(
  sparse_double(c(10, 50, 11), c(1, 50, 111), 1000)
)

sparse_sd(
  sparse_double(c(10, NA, 11), c(1, 50, 111), 1000)
)

sparse_sd(
  sparse_double(c(10, NA, 11), c(1, 50, 111), 1000),
  na_rm = TRUE
)

}
