% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.utilities.R
\name{term_list}
\alias{term_list}
\alias{as.term_list}
\alias{as.term_list.term_list}
\alias{as.term_list.default}
\alias{c.term_list}
\alias{[.term_list}
\alias{print.term_list}
\alias{sign.term_list}
\alias{sign<-.term_list}
\alias{envir.term_list}
\alias{envir<-.term_list}
\title{A helper class for list of terms in an formula}
\usage{
term_list(x, sign = +1L, env = NULL)

as.term_list(x, ...)

\method{as.term_list}{term_list}(x, ...)

\method{as.term_list}{default}(x, sign = +1L, env = NULL, ...)

\method{c}{term_list}(x, ...)

\method{[}{term_list}(x, i, ...)

\method{print}{term_list}(x, ...)

\method{sign}{term_list}(x)

\method{sign}{term_list}(x) <- value

\method{envir}{term_list}(object)

\method{envir}{term_list}(object) <- value
}
\arguments{
\item{x, object}{a list of terms or a term; a \code{term_list}}

\item{sign}{a vector specifying the signs associated with each term (\code{-1} and \code{+1})}

\item{env}{a list specifying the environments, or NULL}

\item{...}{additional arguments to methods}

\item{i}{list index}

\item{value}{RHS; see method documentation}
}
\description{
Typically generated by \code{\link[=list_rhs.formula]{list_rhs.formula()}}, it contains, in
addition to a list of \code{\link[=call]{call()}} or similar objects information about
the sign of the term and the environment of the formula from which
the term has been extracted, accessible and modifiable via \code{\link[=sign]{sign()}}
and \code{\link[=envir]{envir()}} generics. Indexing and concatenation methods preserve
these.
}
\section{Methods (by generic)}{
\itemize{
\item \code{sign(term_list)}: An \code{\link{integer}} vector giving the signs of
each term in the list.

\item \code{sign(term_list) <- value}: Update the signs of the terms; \code{value} is
recycled to the length of the list.

\item \code{envir(term_list)}: A \code{\link{list}} with an element for each term in
the list, giving its environment.

\item \code{envir(term_list) <- value}: Update the environments of the terms; \code{value}
can be an environment or a list of environments, recycled to the
length of the term list.

}}
\examples{

e1 <- new.env()
f1 <- a~b+c
environment(f1) <- e1
f2 <- ~-NULL+1

(l1 <- list_rhs.formula(f1))
(l2 <- list_rhs.formula(f2))

(l <- c(l1,l2))
\dontshow{
stopifnot(identical(c(unclass(l)), alist(b, c, NULL, 1)))
stopifnot(identical(sign(l), c(1L,1L,-1L,1L)))
stopifnot(identical(envir(l), rep(list(e1, globalenv()), each=2)))
}

(l <- c(l2[1], l1[2], l1[1], l1[1], l2[2]))
sign(l)[3] <- -1L
\dontshow{
stopifnot(identical(c(unclass(l)), alist(NULL, c, b, b, 1)))
stopifnot(identical(sign(l), c(-1L,1L,-1L,1L,1L)))
stopifnot(identical(envir(l), list(globalenv(), e1, e1, e1, globalenv())))
}

}
\seealso{
\code{\link[=list_rhs.formula]{list_rhs.formula()}}, \code{\link[=list_summands.call]{list_summands.call()}}
}
