% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case.R
\name{case}
\alias{case}
\alias{str_to_upper}
\alias{str_to_lower}
\alias{str_to_title}
\alias{str_to_sentence}
\title{Convert case of a string.}
\usage{
str_to_upper(string, locale = "en")

str_to_lower(string, locale = "en")

str_to_title(string, locale = "en")

str_to_sentence(string, locale = "en")
}
\arguments{
\item{string}{String to modify}

\item{locale}{Locale to use for translations. Defaults to "en" (English)
to ensure consistent default ordering across platforms.}
}
\description{
Convert case of a string.
}
\examples{
dog <- "The quick brown dog"
str_to_upper(dog)
str_to_lower(dog)
str_to_title(dog)
str_to_sentence("the quick brown dog")

# Locale matters!
str_to_upper("i") # English
str_to_upper("i", "tr") # Turkish
}
