% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcoxzph.R
\name{ggcoxzph}
\alias{ggcoxzph}
\alias{print.ggcoxzph}
\title{Graphical Test of Proportional Hazards with ggplot2}
\usage{
ggcoxzph(
  fit,
  resid = TRUE,
  se = TRUE,
  df = 4,
  nsmo = 40,
  var,
  point.col = "red",
  point.size = 1,
  point.shape = 19,
  point.alpha = 1,
  caption = NULL,
  ggtheme = theme_survminer(),
  ...
)

\method{print}{ggcoxzph}(x, ..., newpage = TRUE)
}
\arguments{
\item{fit}{an object of class \link{cox.zph}.}

\item{resid}{a logical value, if TRUE the residuals are included on the plot,
as well as the smooth fit.}

\item{se}{a logical value, if TRUE, confidence bands at two standard errors
will be added.}

\item{df}{the degrees of freedom for the fitted natural spline, df=2 leads to
a linear fit.}

\item{nsmo}{number of points used to plot the fitted spline.}

\item{var}{the set of variables for which plots are desired. By default, plots
are produced in turn for each variable of a model.}

\item{point.col, point.size, point.shape, point.alpha}{color, size, shape and visibility to be used for points.}

\item{caption}{the caption of the final \link{grob} (\code{bottom} in \link{arrangeGrob})}

\item{ggtheme}{function, ggplot2 theme name.
Allowed values include ggplot2 official themes: see \code{\link[ggplot2]{theme}}.}

\item{...}{further arguments passed to either the print() function or to the \code{\link[ggpubr]{ggpar}} function for customizing the plot (see Details section).}

\item{x}{an object of class ggcoxzph}

\item{newpage}{open a new page. See \code{\link{grid.arrange}}.}
}
\value{
Returns an object of class \code{ggcoxzph} which is a list of ggplots.
}
\description{
Displays a graph of the scaled Schoenfeld residuals, along with a
 smooth curve using \pkg{ggplot2}. Wrapper around \link{plot.cox.zph}.
}
\details{
\strong{Customizing the plots}: The plot can be easily
 customized using additional arguments to be passed to the function ggpar().
 Read ?ggpubr::ggpar. These arguments include
 \emph{font.main,font.submain,font.caption,font.x,font.y,font.tickslab,font.legend}:
 a vector of length 3 indicating respectively the size (e.g.: 14), the style
 (e.g.: "plain", "bold", "italic", "bold.italic") and the color (e.g.: "red")
 of main title, subtitle, caption, xlab and ylab and axis tick labels,
 respectively. For example \emph{font.x = c(14, "bold", "red")}.  Use font.x
 = 14, to change only font size; or use font.x = "bold", to change only font
 face.
}
\section{Functions}{
\itemize{
\item \code{ggcoxzph}: Graphical Test of Proportional Hazards using ggplot2.
}}

\examples{

library(survival)
fit <- coxph(Surv(futime, fustat) ~ age + ecog.ps + rx, data=ovarian)
cox.zph.fit <- cox.zph(fit)
# plot all variables
ggcoxzph(cox.zph.fit)
# plot all variables in specified order
ggcoxzph(cox.zph.fit, var = c("ecog.ps", "rx", "age"), font.main = 12)
# plot specified variables in specified order
ggcoxzph(cox.zph.fit, var = c("ecog.ps", "rx"), font.main = 12, caption = "Caption goes here")

}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
