% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-condition.R
\name{expect_error}
\alias{expect_error}
\alias{expect_condition}
\title{Expectation: does code throw error or other condition?}
\usage{
expect_error(object, regexp = NULL, class = NULL, ..., info = NULL,
  label = NULL)

expect_condition(object, regexp = NULL, class = NULL, ...,
  info = NULL, label = NULL)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{regexp}{Regular expression to test against.
\itemize{
\item A character vector giving a regular expression that must match the
error message.
\item If \code{NULL}, the default, asserts that there should be a error,
but doesn't test for a specific value.
\item If \code{NA}, asserts that there should be no errors.
}}

\item{class}{Instead of supplying a regular expression, you can also supply
a class name. This is useful for "classed" conditions.}

\item{...}{Arguments passed on to \code{expect_match}
\describe{
  \item{all}{Should all elements of actual value match \code{regexp} (TRUE),
or does only one need to match (FALSE)}
  \item{perl}{logical.  Should Perl-compatible regexps be used?}
  \item{fixed}{logical.  If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}
}}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label}{Used to customise failure messages. For expert use only.}
}
\value{
If \code{regexp = NA}, the value of the first argument; otherwise
the captured condition.
}
\description{
\code{expect_error()} and \code{expect_condition()} check that code throws an error
or condition with a message that matches \code{regexp}, or a class that inherits
from \code{class}. See below for more details.
}
\section{Testing \code{message} vs \code{class}}{

When checking that code generates an error, it's important to check that the
error is the one you expect. There are two ways to do this. The first
way is the simplest: you just provide a \code{regexp} that match some fragment
of the error message. This is easy, but fragile, because the test will
fail if the error message changes (even if its the same error).

A more robust way is to test for the class of the error, if it has one.
You can learn more about custom conditions at
\url{https://adv-r.hadley.nz/conditions.html#custom-conditions}, but in
short, errors are S3 classes and you can generate a custom class and check
for it using \code{class} instead of \code{regexp}. Because this is a more reliable
check, you \code{expect_error()} will warn if the error has a custom class but
you are testing the message. Eliminate the warning by using \code{class} instead
of \code{regexp}. Alternatively, if you think the warning is a false positive,
use \code{class = "error"} to suppress it for any input.

If you are using \code{expect_error()} to check that an error message is
formatted in such a way that it makes sense to a human, we now recommend
using \code{\link[=verify_output]{verify_output()}} instead.
}

\examples{
f <- function() stop("My error!")
expect_error(f())
expect_error(f(), "My error!")

# You can use the arguments of grepl to control the matching
expect_error(f(), "my error!", ignore.case = TRUE)

# If you are working with classed conditions, it's better to test for
# the class name, rather than the error message (which may change over time)
custom_err <- function(var) {
  rlang::abort("A special error", var = var, .subclass = "testthat_special")
}
expect_error(custom_err("a"), class = "testthat_special")

# Note that `expect_error()` returns the error object so you can test
# its components if needed
err <- expect_error(custom_err("a"), class = "testthat_special")
expect_equal(err$var, "a")
}
\seealso{
Other expectations: \code{\link{comparison-expectations}},
  \code{\link{equality-expectations}},
  \code{\link{expect_length}}, \code{\link{expect_match}},
  \code{\link{expect_message}}, \code{\link{expect_named}},
  \code{\link{expect_null}}, \code{\link{expect_output}},
  \code{\link{expect_silent}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}}
}
\concept{expectations}
