% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind_graphs}
\alias{bind_graphs}
\alias{bind_nodes}
\alias{bind_edges}
\title{Add graphs, nodes, or edges to a tbl_graph}
\usage{
bind_graphs(.data, ...)

bind_nodes(.data, ...)

bind_edges(.data, ...)
}
\arguments{
\item{.data}{A \code{tbl_graph}}

\item{...}{In case of \code{bind_nodes()} and \code{bind_edges()} data.frames to add.
In the case of \code{bind_graphs()} objects that are convertible to \code{tbl_graph}
using \code{as_tbl_graph()}.}
}
\value{
A \code{tbl_graph} containing the new data
}
\description{
These functions are tbl_graph pendants to \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}} that allows
you to grow your \code{tbl_graph} by adding rows to either the nodes data, the
edges data, or both. As with \code{bind_rows()} columns are matched by name and
are automatically filled with \code{NA} if the column doesn't exist in some
instances. In the case of \code{bind_graphs()} the graphs are automatically
converted to \code{tbl_graph} objects prior to binding. The edges in each graph
will continue to reference the nodes in the graph where they originated,
meaning that their terminal node indexes will be shifted to match the new
index of the node in the combined graph. This means the \code{bind_graphs()}
always result in a disconnected graph. See \code{\link[=graph_join]{graph_join()}} for merging graphs
on common nodes.
}
\examples{
graph <- create_notable('bull')
new_graph <- create_notable('housex')

# Add nodes
graph \%>\% bind_nodes(data.frame(new = 1:4))

# Add edges
graph \%>\% bind_edges(data.frame(from = 1, to = 4:5))

# Add graphs
graph \%>\% bind_graphs(new_graph)

}
