% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent.r
\name{recurrent.marginal.mean}
\alias{recurrent.marginal.mean}
\title{Estimates marginal mean of recurrent events}
\usage{
recurrent.marginal.mean(recurrent, death)
}
\arguments{
\item{recurrent}{aalen model for recurrent events}

\item{death}{aalen model for recurrent events}
}
\description{
Fitting two aalen models for death and recurent events these are
combined to prducte the estimator 
\deqn{ \int_0^t  S(u) dR(u) } the mean number of recurrent events, here
\deqn{ S(u) }  is the probability of survival, and 
\deqn{ dR(u) }  is the probability of an event among survivors.
}
\details{
IID versions used for Ghosh & Lin (2000) variance. See also mets package for 
quick version of this for large data mets:::recurrent.marginal, these two 
version should give the same when there are no ties.
}
\examples{
\donttest{
### get some data using mets simulaitons 
library(mets)
data(base1cumhaz)
data(base4cumhaz)
data(drcumhaz)
dr <- drcumhaz
base1 <- base1cumhaz
base4 <- base4cumhaz
rr <- simRecurrent(100,base1,death.cumhaz=dr)
rr$x <- rnorm(nrow(rr)) 
rr$strata <- floor((rr$id-0.01)/50)
drename(rr) <- start+stop~entry+time

ar <- aalen(Surv(start,stop,status)~+1+cluster(id),data=rr,resample.iid=1
                                                     ,max.clust=NULL)
ad <- aalen(Surv(start,stop,death)~+1+cluster(id),data=rr,resample.iid=1,
                                                     ,max.clust=NULL)
mm <- recurrent.marginal.mean(ar,ad)
with(mm,plot(times,mu,type="s"))
with(mm,lines(times,mu+1.96*se.mu,type="s",lty=2))
with(mm,lines(times,mu-1.96*se.mu,type="s",lty=2))
}
}
\references{
Ghosh and Lin (2002) Nonparametric Analysis of Recurrent events and death, 
                     Biometrics, 554--562.
}
\author{
Thomas Scheike
}
\keyword{survival}
