% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/description.R
\name{use_description}
\alias{use_description}
\alias{use_description_defaults}
\title{Create or modify a DESCRIPTION file}
\usage{
use_description(fields = NULL)

use_description_defaults()
}
\arguments{
\item{fields}{A named list of fields to add to \code{DESCRIPTION}, potentially
overriding default values. See \code{\link[=use_description]{use_description()}} for how you can set
personalized defaults using package options}
}
\description{
usethis consults the following sources, in this order, to set \code{DESCRIPTION}
fields:
\itemize{
\item \code{fields} argument of \code{\link[=create_package]{create_package()}} or \code{\link[=use_description]{use_description()}}.
\item \code{getOption("usethis.description")} or \code{getOption("devtools.desc")}. The
devtools option is consulted only for backwards compatibility and it's
recommended to switch to an option named "usethis.description".
\item Defaults built into usethis.
}

The fields discovered via options or the usethis package can be viewed with
\code{use_description_defaults()}.

If you create a lot of packages, consider storing personalized defaults as a
named list in an option named \code{"usethis.description"}. Here's an example of
code to include in \code{.Rprofile}:\preformatted{options(
  usethis.description = list(
    `Authors@R` = 'person("Jane", "Doe", email = "jane@example.com", role = c("aut", "cre"),
                          comment = c(ORCID = "YOUR-ORCID-ID"))',
    License = "MIT + file LICENSE",
    Language =  "es"
  )
)
}
}
\examples{
\dontrun{
use_description()

use_description(fields = list(Language = "es"))

use_description_defaults()
}
}
\seealso{
The \href{https://r-pkgs.org/description.html#dependencies}{description chapter}
of \href{https://r-pkgs.org}{R Packages}.
}
