\name{phase.shift.hilbert}
\alias{phase.shift.hilbert}
\alias{phase.shift.hilbert.packet}
\title{Phase Shift for Hilbert Wavelet Coefficients}
\description{
  Wavelet coefficients are circularly shifted by the amount of phase
  shift induced by the discrete Hilbert wavelet transform.
}
\usage{
phase.shift.hilbert(x, wf)
phase.shift.hilbert.packet(x, wf)
}
\arguments{
  \item{x}{Discete Hilbert wavelet transform (DHWT) object.}
  \item{wf}{character string; Hilbert wavelet pair used in DHWT}
}
\value{
  DHWT (DHWPT) object with coefficients circularly shifted.
}
\details{
  The "center-of-energy" argument of Hess-Nielsen and Wickerhauser
  (1996) is used to provide a flexible way to circularly shift wavelet 
  coefficients regardless of the wavelet filter used.
}
\references{
  Hess-Nielsen, N. and M. V. Wickerhauser (1996)
  Wavelets and time-frequency analysis,
  \emph{Proceedings of the IEEE}, \bold{84}, No. 4, 523-540.
}
\seealso{
  \code{\link{phase.shift}}
}
%\examples{}
\author{B. Whitcher}
\keyword{ts}
