% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mw-cgi.R
\name{mw_cgi}
\alias{mw_cgi}
\title{Middleware that calls a CGI script}
\usage{
mw_cgi(command, args = character(), timeout = as.difftime(Inf, units = "secs"))
}
\arguments{
\item{command}{External command to run.}

\item{args}{Arguments to pass to the external command.}

\item{timeout}{Timeout for the external command. If the command does
not terminate in time, the web server kills it and returns an 500
response.}
}
\value{
A function with signature

\if{html}{\out{<div class="sourceCode">}}\preformatted{function(req, res, env = character())
}\if{html}{\out{</div>}}

See \href{https://www.ietf.org/rfc/rfc3875}{RFC 3875} for details on the CGI
protocol.

The request body (if any) is passed to the external command as standard
intput. \code{mw_cgi()} sets \code{CONTENT_LENGTH}, \code{CONTENT_TYPE},
\code{GATEWAY_INTERFACE}, \code{PATH_INFO}, \code{QUERY_STRING}, \code{REMOTE_ADDR},
\code{REMOTE_HOST}, \code{REMOTE_USER}, \code{REQUEST_METHOD}, \code{SERVER_NAME},
\code{SERVER_PORT}, \code{SERVER_PROTOCOL}, \code{SERVER_SOFTEWARE}.

It does not currently set the \code{AUTH_TYPE}, \code{PATH_TRANSLATED},
\code{REMOTE_IDENT}, \code{SCRIPT_NAME} environment variables.

The standard output of the external command is used to set the
response status code, the response headers and the response body.
Example output from git's CGI:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Status: 200 OK
Expires: Fri, 01 Jan 1980 00:00:00 GMT
Pragma: no-cache
Cache-Control: no-cache, max-age=0, must-revalidate
Content-Type: application/x-git-upload-pack-advertisement

000eversion 2
0015agent=git/2.42.0
0013ls-refs=unborn
0020fetch=shallow wait-for-done
0012server-option
0017object-format=sha1
0010object-info
0000
}\if{html}{\out{</div>}}
}
\description{
You can use it as an unconditional middleware in \code{app$use()},
as a handler on \code{app$get()}, \code{app$post()}, etc., or you can call it
from a handler. See examples below.
}
\examples{
app <- new_app()
app$use(mw_cgi("echo", "Status: 200\n\nHello"))
app

app2 <- new_app()
app2$get("/greet", mw_cgi("echo", "Status: 200\n\nHello"))
app2

# Using `mw_cgi()` in a handler, you can pass extra environment variables
app3 <- new_app()
cgi <- mw_cgi("echo", "Status: 200\n\nHello")
app2$get("/greet", function(req, res) {
  cgi(req, res, env = c("EXTRA_VAR" = "EXTRA_VALUE"))
})
app3
}
\seealso{
Other middleware: 
\code{\link{mw_cookie_parser}()},
\code{\link{mw_etag}()},
\code{\link{mw_json}()},
\code{\link{mw_log}()},
\code{\link{mw_multipart}()},
\code{\link{mw_range_parser}()},
\code{\link{mw_raw}()},
\code{\link{mw_static}()},
\code{\link{mw_text}()},
\code{\link{mw_urlencoded}()}
}
\concept{middleware}
