#include <stdio.h>
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

#include "slist.h"

struct node {
  int id;
  struct slist list;
};

void node_init(struct node* self) {
  self->id = 0;
  slist_init(&self->list);
}

void node_print(struct node* self) {
  printf("node %d\n", self->id);
}

int find_two(struct node* self) {
  if (self->id == 2) return 0; else return 1;
}

int main() {
  struct node h, a, b, c;
  node_init(&h); a.id = 0;
  node_init(&a); a.id = 1;
  node_init(&b); b.id = 2;
  node_init(&c); c.id = 3;
  slist_extend(&h.list, &a.list);
  slist_extend(&a.list, &b.list);
  slist_extend(&b.list, &c.list);

  slist_for(struct node, list, &h, &node_print);
  slist_search(struct node, list, &h, found, not_found, &find_two);

found:
  printf("found two\n");
  return 0;

not_found:
  printf("two not found\n");
  return 1;
}
