# Announce: Rakudo Perl 6 compiler, Development Release #93 (“Bend”)

On behalf of the Rakudo development team, I’m very happy to announce the November
2015 release of Rakudo Perl 6 #93 “Bend”. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1] and the Java Virtual Machine.

This is the final pre-Christmas release of Rakudo Perl 6. It’s the second
release candidate/beta of the compiler for the anticipated 6.0 “Christmas”
release.

The “Christmas” release will occur on or about 17 December 2015, assuming
no critical bugs are found between now and then. Please try the release,
your feedback is greatly appreciated.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This month’s release is named after
the Bend chapter, because we’re nearly around the bend with the upcoming
Christmas release.

Some of the changes in this release are outlined below:

New in 2015.11:
   + Initial shaped array support
   + \r\n (Carriage Return/LineFeed) is now a single (synthetic) grapheme
   + Unicode support adheres to Unicode Annex #29
   + Unicode quotes are now also allowed in regular expressions
   + Improved newline support with "use newline" and updates to IO::Handle
   + Added List.head, List.tail, List.repeated methods
   + Str.encode now allows :replacement parameter for unencodable sequences
   + Str.split now accepts multiple strings to split on
   + New Range.int-bounds returns first/last value for integer ranges
   + Auto-generated meta-ops vivified by referring to them, instead of executing
   + Illegal assignment of different Numeric values now caught at compile time
   + &nextcallee implemented, which returns the routine that nextsame would invoke
   + Many speedups

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
the design docs, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:

Jonathan Worthington, Elizabeth Mattijsen, Larry Wall, Pawel Murias, Will "Coke" Coleda, Christian Bartolomäus, Pepe Schwarz, Timo Paulssen, Tobias Leich, Mike Francis, Nicholas Clark, Dagfinn Ilmari Mannsåker, Moritz Lenz, Steve Mynott, Jens Rehsack, cygx, Stefan Seifert, Jimmy Zhuo, Nick Logan, Lucas Buchala, Zoffix Znet, Donald Hunter, Lloyd Fournier, Ronald Schmidt, Bart Wiegmans, Tomasz Konojacki, Sterling Hanenkamp, Vladimir Lettiev, Faye Niemeyer, johnspurr, Tim Smith, Rob Hoelz, grondilu

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#94), is tentatively scheduled for 17 December 2015.
Because that release will correspond with the Perl 6 Christmas version of
the specification, we may end up delaying the release to insure the
best possible release.

A list of the other planned release dates and code names for future
releases is available in the “docs/release_guide.pod” file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility. Rakudo Star
is meant for early adopters who wish to explore what’s possible with
Rakudo Perl 6 and provide feedback on what works, what doesn’t, and
what else they would like to see included in the distribution.
