// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SerialPort.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.serial {
  public class SerialPort_3_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("serial.SerialPort:3.0.1", null);

    public SerialPort_3_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public SerialPort_3_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new SerialPort_3_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new SerialPort_3_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int ERR_INVALID_VALUE = 1;

    public enum PortState {
      CONSOLE,
      ANALOGMODEM,
      GSMMODEM,
      DISCONNECTED,
    }

    public enum DetectionType {
      AUTOMATIC,
      FORCE_CONSOLE,
      FORCE_ANALOGMODEM,
      FORCE_GSMMODEM,
    }

    public enum BaudRate {
      BR1200,
      BR2400,
      BR4800,
      BR9600,
      BR19200,
      BR38400,
      BR57600,
      BR115200,
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.hasModemSupport = this.hasModemSupport;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["hasModemSupport"] = this.hasModemSupport;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.hasModemSupport = (bool)json["hasModemSupport"];
        return inst;
      }

      public bool hasModemSupport = false;
    }

    public class State : ICloneable {
      public object Clone() {
        State copy = new State();
        copy.state = this.state;
        copy.deviceName = this.deviceName;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["state"] = (int)this.state;
        json["deviceName"] = this.deviceName;
        return json;
      }

      public static State Decode(LightJson.JsonObject json, Agent agent) {
        State inst = new State();
        inst.state = (Com.Raritan.Idl.serial.SerialPort_3_0_1.PortState)(int)json["state"];
        inst.deviceName = (string)json["deviceName"];
        return inst;
      }

      public Com.Raritan.Idl.serial.SerialPort_3_0_1.PortState state = Com.Raritan.Idl.serial.SerialPort_3_0_1.PortState.CONSOLE;
      public string deviceName = "";
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.consoleBaudRate = this.consoleBaudRate;
        copy.modemBaudRate = this.modemBaudRate;
        copy.detectType = this.detectType;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["consoleBaudRate"] = (int)this.consoleBaudRate;
        json["modemBaudRate"] = (int)this.modemBaudRate;
        json["detectType"] = (int)this.detectType;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.consoleBaudRate = (Com.Raritan.Idl.serial.SerialPort_3_0_1.BaudRate)(int)json["consoleBaudRate"];
        inst.modemBaudRate = (Com.Raritan.Idl.serial.SerialPort_3_0_1.BaudRate)(int)json["modemBaudRate"];
        inst.detectType = (Com.Raritan.Idl.serial.SerialPort_3_0_1.DetectionType)(int)json["detectType"];
        return inst;
      }

      public Com.Raritan.Idl.serial.SerialPort_3_0_1.BaudRate consoleBaudRate = Com.Raritan.Idl.serial.SerialPort_3_0_1.BaudRate.BR1200;
      public Com.Raritan.Idl.serial.SerialPort_3_0_1.BaudRate modemBaudRate = Com.Raritan.Idl.serial.SerialPort_3_0_1.BaudRate.BR1200;
      public Com.Raritan.Idl.serial.SerialPort_3_0_1.DetectionType detectType = Com.Raritan.Idl.serial.SerialPort_3_0_1.DetectionType.AUTOMATIC;
    }

    public class ModemEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("serial.SerialPort_3_0_1.ModemEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public ObjectProxy modem = null;
    }

    public class ModemAddedEvent : Com.Raritan.Idl.serial.SerialPort_3_0_1.ModemEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("serial.SerialPort_3_0_1.ModemAddedEvent:1.0.0", Com.Raritan.Idl.serial.SerialPort_3_0_1.ModemEvent.typeInfo);

    }

    public class ModemRemovedEvent : Com.Raritan.Idl.serial.SerialPort_3_0_1.ModemEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("serial.SerialPort_3_0_1.ModemRemovedEvent:1.0.0", Com.Raritan.Idl.serial.SerialPort_3_0_1.ModemEvent.typeInfo);

    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.serial.SerialPort_3_0_1.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.serial.SerialPort_3_0_1.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.serial.SerialPort_3_0_1.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.serial.SerialPort_3_0_1.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.serial.SerialPort_3_0_1.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.serial.SerialPort_3_0_1.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.serial.SerialPort_3_0_1.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.serial.SerialPort_3_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.serial.SerialPort_3_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetStateResult {
      public Com.Raritan.Idl.serial.SerialPort_3_0_1.State _ret_;
    }

    public GetStateResult getState() {
      JsonObject _parameters = null;
      var _result = RpcCall("getState", _parameters);
      var _ret = new GetStateResult();
      _ret._ret_ = Com.Raritan.Idl.serial.SerialPort_3_0_1.State.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getState(AsyncRpcResponse<GetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getState(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getState(AsyncRpcResponse<GetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getState", _parameters,
        _result => {
          try {
            var _ret = new GetStateResult();
            _ret._ret_ = Com.Raritan.Idl.serial.SerialPort_3_0_1.State.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetModemResult {
      public ObjectProxy _ret_;
    }

    public GetModemResult getModem() {
      JsonObject _parameters = null;
      var _result = RpcCall("getModem", _parameters);
      var _ret = new GetModemResult();
      _ret._ret_ = ObjectProxy.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getModem(AsyncRpcResponse<GetModemResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getModem(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getModem(AsyncRpcResponse<GetModemResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getModem", _parameters,
        _result => {
          try {
            var _ret = new GetModemResult();
            _ret._ret_ = ObjectProxy.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
