<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN">

<style-sheet>
<style-specification>
<style-specification-body>

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; This file is part of refdb
;; Markus Hoenicka 001124
;; markus@mhoenicka.de
;; $Id: citations.dsl,v 1.8 2004/03/19 23:23:11 mhoenicka Exp $
;;
;;
;;; The purpose of this stylesheet is to extract a list of the contents of
;;; all citation elements in the text. The latter are "citation" in DocBook
;;; and 'seg type="REFDBCITATION"' in TEI. The result will be an XML file
;;; containing the CITATION elements and their XREF children
;;; NB it is possible to add code for further document types to this file
;;; as long as no top-level element names overlap
;
;;; Processing: jade -t xml -d citations.dsl [sgml-declaration] infile > outfile

(declare-flow-object-class element
			   "UNREGISTERED::James Clark//Flow Object Class::element")
(declare-flow-object-class processing-instruction
			   "UNREGISTERED::James Clark//Flow Object Class::processing-instruction")

(declare-flow-object-class document-type
  "UNREGISTERED::James Clark//Flow Object Class::document-type")

;; start user-customizable section

;; the path to the citationlistx dtd
;;(define SYSTEMCITID "/usr/local/lib/sgml/dtd/citationlistx.dtd")
(define SYSTEMCITID "http://refdb.sourceforge.net/dtd/citationlistx.dtd")

;; end user-customizable section

(define PUBLICCITID "-//Markus Hoenicka//DTD CitationList//EN")

;*****************************************************************
; DocBook
;*****************************************************************
(element book
  (make sequence
    (make processing-instruction 
      data: "xml version=\"1.0\" standalone=\"no\"")
; this doctype line will not be well-formed in both jade and openjade and
; thus needs post-processing
    (make document-type
      name: "CITATIONLIST"
      public-id: PUBLICCITID
      system-id: SYSTEMCITID)
    (make element
      gi: "CITATIONLIST"
      (process-node-list (select-elements (descendants (current-node)) (normalize "citation"))))))

(element article
  (make sequence
    (make processing-instruction 
      data: "xml version=\"1.0\" standalone=\"no\"")
    (make document-type
      name: "CITATIONLIST"
      public-id: PUBLICCITID
      system-id: SYSTEMCITID)
    (make element
      gi: "CITATIONLIST"
      (process-node-list (select-elements (descendants (current-node)) (normalize "citation"))))))

(element citation
  (if (equal? (normalize (attribute-string (normalize "role"))) "REFDB")
      (make sequence
	(make element
	  gi: "CITATION"
	  (process-node-list (select-elements (children (current-node)) (normalize "xref")))))
      (empty-sosofo)))

(element xref
  (make sequence
    (if (attribute-string (normalize "ENDTERM"))
	(make element
	  gi: "XREF"
	  attributes: (list (list "ENDTERM" (attribute-string (normalize "endterm"))))
	  (literal (strip-refdb-suffix (attribute-string (normalize "linkend")))))
	(make element
	  gi: "XREF"
	  (literal (strip-refdb-suffix (attribute-string (normalize "linkend"))))))))

;*****************************************************************
; TEI
;*****************************************************************
(element TEI.2
  (make sequence
    (make processing-instruction 
      data: "xml version=\"1.0\" standalone=\"no\"")
    (make document-type
      name: "CITATIONLIST"
      public-id: PUBLICCITID
      system-id: SYSTEMCITID)
    (make element
      gi: "CITATIONLIST"
      (process-node-list (select-elements (descendants (current-node)) (normalize "seg"))))))

(element seg
  (if (equal? (attribute-string (normalize "type")) "REFDBCITATION")
      (make sequence
	(make element
	  gi: "CITATION"
	  (process-node-list (select-elements (children (current-node)) (normalize "ptr")))))
      (empty-sosofo)))

(element ptr
  (make sequence
    (if (equal? (normalize (attribute-string (normalize "type"))) "MULTIXREF")
	(make element
	  gi: "XREF"
	  attributes: (list (list "ENDTERM" (attribute-string (normalize "target"))))
	  (literal (strip-refdb-suffix (attribute-string (normalize "target") (node-list-first (follow (current-node)))))))
	(make element
	  gi: "XREF"
	  (literal (strip-refdb-suffix (attribute-string (normalize "target"))))))))


;*****************************************************************
; library stuff
;*****************************************************************
(define (normalize str)
  ;; REFENTRY normalize
  ;; PURP Normalize the str according to the SGML declaration in effect
  ;; DESC
  ;; Performs SGML general name normalization on the string;
  ;; used to compare attribute names and generic identifiers correctly
  ;; according to the SGML declaration in effect; this is necessary
  ;; since XML is case-sensitive but the reference concrete syntax and
  ;; many SGML DTDs are not.
  ;; /DESC
  ;; AUTHOR Chris Maden
  ;; /REFENTRY
  (if (string? str)
      (general-name-normalize str
			      (current-node))
      str))

(define (strip-refdb-suffix str)
  ;; REFENTRY strip-refdb-suffix
  ;; PURP strips off trailing link type specifier and separator in ID
  ;; DESC
  ;; RefDB citations use ID values in the formats "IDnumerical_id:X" 
  ;; or "IDalphanumeric_citekey:X where ID is the invariant part,
  ;; followed by a number or a citekey of unlimited length, which is
  ;; followed by a separator and an one-char specifier for the text
  ;; which is to be rendered with the link. Stripping off
  ;; this specifier simplifies downstream processing
  ;; /DESC
  ;; AUTHOR Markus Hoenicka
  ;; /REFENTRY
  (let ((strlen (string-length str)))
    (if (equal? (substring str (- strlen 2) (- strlen 1)) "-")
	(substring str 0 (- strlen 2))
	str)))

</style-specification-body>
</style-specification>
</style-sheet>


