# crack P1
# comparaison
#   uniforme de pas h 
#   adapte avec hmin = coef^2
#
# representation des erreurs L2, Linf et H1
# en fct de h_equiv = 1/sqrt(n_elt)
#
# format adapt.dat:
# coef niter n_node n_elt hmin hmax err_l2 err_infty err_h1
#  1     2     3     4     5    6    7       8        9

# format uniform.dat:
# i n_node n_elt h err_l2 err_infty err_h1
# 1   2      3   4   5       6        7

set logscale
set size square

set xlabel "h ~ coef"

set title "erreur H1"
plot "crack-uniform-P1.dat" u 4:7 w lp, \
     "crack-adapt-P1.dat"   u 1:9 w lp, \
     0.1*x**0.5, 0.1*x
pause -1 "<retour>"

set title "erreur L2"
plot "crack-uniform-P1.dat" u 4:5 w lp, \
     "crack-adapt-P1.dat"   u 1:7 w lp, \
     0.1*x, 0.1*x**(1.5), 0.1*x**2
pause -1 "<retour>"

set title "erreur Linf"
plot "crack-uniform-P1.dat" u 4:6 w lp, \
     "crack-adapt-P1.dat"   u 1:8 w lp, \
     0.1*x**0.5, 0.1*x**2
pause -1 "<retour>"

set xlabel "1/sqrt(n_elt)"

set title "erreur H1"
plot "crack-uniform-P1.dat" u (1/sqrt($3)):7 w lp, \
     "crack-adapt-P1.dat" u (1/sqrt($4)):9 w lp, \
     0.1*x**0.5
pause -1 "<retour>"

set title "erreur L2"
plot "crack-uniform-P1.dat" u (1/sqrt($3)):5 w lp, \
     "crack-adapt-P1.dat" u (1/sqrt($4)):7 w lp, \
     0.1*x, 0.1*x**(1.5)
pause -1 "<retour>"

set title "erreur Linf"
plot "crack-uniform-P1.dat" u (1/sqrt($3)):6 w lp, \
     "crack-adapt-P1.dat" u (1/sqrt($4)):8 w lp, \
     0.1*x**0.5
pause -1 "<retour>"

set xlabel "coef"
set title "n_elt = f(coef) pour hmin=coef^2"
plot "crack-adapt-P1.dat" u 1:4 w lp, \
     1/x**4
pause -1 "<retour>"

set title "hmin = f(coef)"
plot "crack-adapt-P1.dat" u 1:5 w lp, \
     x**2
pause -1 "<retour>"

set title "hmax = f(coef)"
plot "crack-adapt-P1.dat" u 1:6 w lp, \
     x
pause -1 "<retour>"

