///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/numbering.h"
using namespace rheolef;
using namespace std;

int
main (int argc, const char **argv)
{
  if (argc != 2) {
      cerr << "usage: " << argv[0] << " <base>" << endl;
      exit (1);
  }
  {
    numbering num(string(argv[1]) + "_numbering");
    size_t  dim = 2;
    size_t  n = 10;
    size_t  count_geo [4];
    size_t  count_element [reference_element::max_variant];
    count_geo [0] = (n+1)*(n+1);
    count_geo [1] = 2*n*(n+1) + n*n;
    count_geo [2] = 2*n*n;
    count_geo [3] = 0;
    count_element [reference_element::p] = count_geo [0];
    count_element [reference_element::e] = count_geo [1];
    count_element [reference_element::t] = count_geo [2];
    count_element [reference_element::q] = 0;
    count_element [reference_element::T] = 0;
    count_element [reference_element::P] = 0;
    count_element [reference_element::H] = 0;
    size_t ndof = num.ndof (dim, count_geo, count_element);

    cout << "\tndof => " << ndof << endl;
  }
  return 0;
}
