#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "poiseuille.h"

int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo  omega (argv[1]);
  space X1h (omega, "P1", "vector");
  space Bh  (omega, "bubble", "vector");
  space Qh  (omega, "P1");
  space Wh  (omega["upstream"], "P1");
  X1h.block ("wall");
  X1h.block ("upstream");
  X1h[1].block ("axis");
  X1h[1].block ("downstream");
  trial u1 (X1h), ub (Bh), p (Qh);
  test  v1 (X1h), vb (Bh), q (Qh);
  form mp = integrate (p*q);
  form b1 = integrate (-div(u1)*q);
  form bb = integrate (-div(ub)*q);
  form a1 = integrate (2*ddot(D(u1),D(v1)));
  form_option_type fopt;
  fopt.invert = true;
  form inv_ab = integrate (2*ddot(D(ub),D(vb)), fopt);
  form c = bb*inv_ab*trans(bb);
  field u1h (X1h, 0), ph (Qh, 0);
  string sys_coord = omega.coordinate_system_name();
  Float cr = omega.xmax()[1];
  u1h[0]["upstream"] = interpolate (Wh, u_poiseuille(cr,sys_coord));
  solver_abtb stokes (a1.uu(), b1.uu(), c.uu(), mp.uu());
  stokes.solve (-(a1.ub()*u1h.b()), -(b1.ub()*u1h.b()),
                u1h.set_u(),        ph.set_u());
  dout << catchmark("inv_lambda") << 0 << endl
       << catchmark("u")  << u1h
       << catchmark("p")  << ph;
}
