#include "rheolef.h"
#include "helmholtz_band_assembly.h"
#include "sphere.h"
using namespace std;
using namespace rheolef;
int main (int argc, char**argv) {
  geo Lambda (argv[1]);
  size_t d = Lambda.dimension();
  space Vh (Lambda, "P1");
  field phi_h_lambda = interpolate(Vh, phi);
  geo beta_h = banded_level_set (phi_h_lambda);
  space Bh (phi_h_lambda, "banded_level_set");
  Bh.block("isolated");
  form m (Bh, Bh, "mass_s",      phi_h_lambda);
  form a (Bh, Bh, "grad_grad_s", phi_h_lambda);
  a = m+a;
  field fh = interpolate(Bh, f(d));
  field lh = m*fh;
  field phi_h = interpolate(Bh, phi);
  csr<Float> A = band_assembly<Float> (a, phi_h);
  vec<Float> L(A.nrow(), 0.0);
  for (size_t i = 0; i < lh.u.size(); i++) L.at(i) = lh.u.at(i);
  for (size_t i = lh.u.size(); i < L.size(); i++) L.at(i) = 0;
  vec<Float> U (L.size());
  ssk<Float> fact_A = ldlt(A);
  U = fact_A.solve(L);
  field uh(Bh);
  uh.b = 0;
  for (size_t i = 0; i < uh.u.size(); i++) uh.u.at(i) = U.at(i);
  Bh.get_geo().save();
  cout << setprecision(numeric_limits<Float>::digits10)
       << catchmark("u")   << uh
       << catchmark("phi") << phi_h;
}
