set terminal pslatex color auxfile
set output "p-laplacian-square-r1.tex"

set logscale y
set size square 0.7
set xtics (0,500)
set ytics (\
        "[r]{$10^{-15}$}" 1e-15, \
        "[r]{$10^{-10}$}" 1e-10, \
        "[r]{$10^{-5}$}" 1e-5, \
        "[r]{$10^{0}$}" 1 )
set xlabel "[c]{$n$}"
set  label "[r]{\\Large $\\|r_h\\|_{-1,h}$}" at graph -0.05,0.5

plot [0:500][1e-15:1] \
  "p-laplacian-square-p=2.5.gdat" title "[r]{$p=2.50$}" w l, \
  "p-laplacian-square-p=2.9.gdat" title "[r]{$p=2.90$}" w l, \
  "p-laplacian-square-p=2.95.gdat" title "[r]{$p=2.95$}" w l

#pause -1 "<retour>"

