#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
# --------------------------------------------------------------------
# run tests on scalar problems
# --------------------------------------------------------------------
TMPDIR=${TMPDIR-"/tmp"}
SBINDIR=${SBINDIR-"../../nfem/sbin"}
BINDIR=${BINDIR-"../../nfem/bin"}
SRCDIR=${SRCDIR-"../../../rheolef/doc/usrman"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../../nfem/basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../../nfem/basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../../nfem/form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

status=0

command="${SBINDIR}/mkgeo_grid_1d 10       -boundary > line.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

command="${SBINDIR}/mkgeo_grid_2d 10 10    -boundary > square.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

command="${SBINDIR}/mkgeo_grid_3d  3  3  3 -boundary | ${BINDIR}/geo -upgrade -geo - > cube.geo"
echo "      $command"
eval $command 2>/dev/null 
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

prgs="dirichlet dirichlet-nh neumann robin"
pols="P1 P2"
geos="line square cube"
tmp="$TMPDIR/field-$$"
for p in $prgs; do
  for g in $geos; do
    for r in $pols; do
      command="./$p $g $r | ${BINDIR}/field -text -round -ndigit 15 -"
      echo "      $command"
      eval $command > $tmp.field 2>/dev/null
      if test $? -ne 0; then status=1; echo "        => *NO*"; continue; fi
      gzip -d < ${SRCDIR}/$p-$g-$r.field.valid.gz | diff - $tmp.field >/dev/null
      if test $? -ne 0; then status=1; echo "        => *NO*"; fi
    done
  done
done

# --------------------------------------------------------------------
# Neumann BC for the Laplace operator
# --------------------------------------------------------------------
prgs="neumann-laplace"
pols="P1 P2"
geos="line square cube"
tmp="$TMPDIR/field-$$"
for p in $prgs; do
  for g in $geos; do
    for r in $pols; do
      command="./$p $g $r | ./$p-tst"
      echo "      $command"
      eval $command 2>/dev/null
      if test $? -ne 0; then status=1; echo "        => *NO*"; continue; fi
    done
  done
done

# --------------------------------------------------------------------
# clean
# --------------------------------------------------------------------
command="/bin/rm -f line.geo square.geo cube.geo"
echo "      $command"
eval $command
/bin/rm -f $tmp.field

exit $status

