///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// mass matrix for scalar, vectorial and tensorial valued space
//
// for symmetric tensorial valued space, the matrix mass is block-diagonal
// with a 2 factor for (i,j) blocks, 0 <= i,j < 3 when i != j
//
#include "mass.h"
#include "rheolef/ublas_matrix_range.h"
using namespace rheolef;
using namespace std;
using namespace ublas;

void 
mass::operator() (const geo_element& K, ublas::matrix<Float>& m) const
{
  build_general_mass (K, m);
}
void
mass::check_after_initialize () const
{
  // suppose also that multi-component spaces are homogeneous,
  // i.e. that all components have the same approx
  check_macro (get_first_space().n_component() == get_second_space().n_component(),
    "incompatible spaces for the `mass' form.");
  if (is_weighted() && get_first_space().dimension() != 1) {
    fem_helper::valued_field_type weight_valued = _wh.get_valued_type();
    if (weight_valued != fem_helper::scalar) {
      // first case : vector space and tensor weight
      //     m(u,v) = int_Omega w_ij u_j v_i dx
      // second case : tensor space and tensor4 weight
      //     m(tau,gamma) = int_Omega w_ijkl tau_kj gamma_ij dx
      fem_helper::valued_field_type space_valued = get_first_space().get_valued_type();
      if (weight_valued == fem_helper::tensorial) {
	  check_macro (space_valued == fem_helper::vectorial, "mass form: unexpected tensorial weight and "
			  << get_first_space().get_valued() << " space");
      } else if (weight_valued == fem_helper::tensorial_4) {
	  check_macro (space_valued == fem_helper::tensorial, "mass form: unexpected tensorial weight and "
			  << get_first_space().get_valued() << " space");
      } else {
          error_macro ("mass form: unexpected " << _wh.get_valued() << " weight and "
			  << get_first_space().get_valued() << " space");
      }
    }
  }
}
