#ifndef _RHEO_ADAPT_ZZ_H
#define _RHEO_ADAPT_ZZ_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/field.h"
#include "rheolef/adapt_option.h"
namespace rheolef { 

// isotropic adaptation: return the mesh size h_local
field h_local_estim (const field& grad_uh, const adapt_option_type& options = adapt_option_type(), std::string method = "macro", bool do_proj = true);

// anisotropic adaptation:
// estimation from the current solution:
// return the metric M such that
// the size in the direction v
// is h(v) = |v|/sqrt(v'*M*v)
// suitable for bamg.
// example : an isotropic metric is: M(x) = h(x)^{-2}.I
field h_local_estim_aniso (const field& grad_uh, const adapt_option_type& options = adapt_option_type(), std::string method = "macro");

// misc: get size informations from the mesh, from various methods
field h_local       (const geo& omega);
field h_local_aniso (const geo& omega);
field h_local_iso   (const geo& omega);
}// namespace rheolef
#endif // _RHEO_ADAPT_ZZ_H
