#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../../../rheolef"}
NPROC_MAX=${NPROC_MAX-"8"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

run "../sbin/mkgeo_grid_2d -t 2 -v4 2>/dev/null | ../pbin/geo -upgrade - > tmp.geo 2>/dev/null"
if test $? -ne 0; then status=1; fi

loop_mpirun "./branch_variadic_io_tst tmp.geo o > tmp.branch 2>/dev/null && ./branch_variadic_io_tst tmp.geo io < tmp.branch 2>/dev/null | diff tmp.branch - >/dev/null"
if test $? -ne 0; then status=1; fi

run "rm -f tmp.branch tmp.geo"

exit $status
