#!/bin/sh -x
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"../../../rheolef/nfem/tst"}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
DATA_DIR="${TOP_SRCDIR}/nfem/data"
NPROC_MAX=${NPROC_MAX-"1"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

#HAVE_LU_SOLVER=${HAVE_LU_SOLVER-"yes"}
if test x"${HAVE_LU_SOLVER}" = x""; then
    echo "        => skipped since UMFPACK is not available: no sparse LU factorization"
    exit 0
fi

status=0

run "../sbin/mkgeo_grid_2d 10 > square.geo 2>/dev/null"

run "./form_convect_dg_tst square.geo 2>/dev/null | ../bin/branch - -extract 500 2>/dev/null | diff $SRCDIR/form_convect_dg_tst.out.valid - >/dev/null"
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

run "/bin/rm -f square.geo"

exit ${status}

