# ------------------------------------------------------------------------------
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
# font utility
# ----------------------------------------------------------------------

# ----------------------------------------------------------------------
# USAGE: get_dpi <window>
#
# Get the pixel-per-inch resolution for the current window.
# If not argument, the main window "." is assumed
# ----------------------------------------------------------------------
proc get_dpi {{win "."}} {
    set pixel_per_point [tk scaling -displayof $win]
    set point_per_inch  [expr 72.0]
    set pixel_per_inch  [expr int($pixel_per_point*$point_per_inch+0.5)]
    return $pixel_per_inch
}
# ----------------------------------------------------------------------
# USAGE: font_best ?window? <family> <family>... <option> <value>...
#
# Creates a new font with an automatically generated name.  If the
# first <family> is not installed, then the font defaults to the next
# family, and the next, and so on.  If none of the families are
# installed, the font defaults to a system face.  The remaining
# arguments are treated as <option> <value> pairs like "-size 10",
# used to configure the font.
#
# The -pxsize <pxsize> option is supported, where <pxsize> is
# the size in pixel units. The -size <size> option corresponds
# to a size in point units. Since the conversion from pixels
# to point depends upon the window (see "tk scaling"), the
# first argument is an optional window. If no window is provided,
# then "." is assumed.
# ----------------------------------------------------------------------
proc font_best {args} {
    set win  [lindex $args 0]
    if {[winfo exists $win]} {
       set args [lrange $args 1 end]
    } else {
       set win "."
    }
    # --------------------
    # scan args for family
    # --------------------
    set family ""
    set fname  [font create]
    while {[llength $args] > 0} {
        set arg0 [lindex $args 0]
        if {[string index $arg0 0] == "-"} {
            break
        }
        set args [lrange $args 1 end]

        if {$family == ""} {
            font configure $fname -family $arg0
            if {[font actual $fname -family] == $arg0} {
                set family $arg0
            }
        }
    }
    # --------------------
    # scan args for px-size
    # --------------------
    set new_args ""
    while {[llength $args] > 0} {
        set arg0 [lindex $args 0]
        set args [lrange $args 1 end]
        if {$arg0 != "-pxsize"} {
	    set new_args "$new_args $arg0"
	    continue
	}
        if {[llength $args] <= 0} {
	    break
	}
        set pxsize [lindex $args 0]
	if {$pxsize < 0 || $pxsize > 150} {
	    eval error "unexpected pixel size \"$pxsize\" for family \"$family\" and window \"$win\"."
        }
        set args [lrange $args 1 end]
    	set dpi [get_dpi $win]
	set size [expr (72./$dpi)*$pxsize]
	set size [format %d [expr int($size+0.5)]]
	set new_args "$new_args -size $size"
    }
    # --------------------
    # load font
    # --------------------
    eval font configure $fname $new_args
    return $fname
}
