#ifndef _SKIT_BLAS2_TMPL_H
#define _SKIT_BLAS2_TMPL_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// blas 2 expression without template expression
//
// author: Pierre.Saramito@imag.fr
//
// date: 7 march 1997
//
# include "rheolef/blas-algorithm.h"
# include "rheolef/csr.h"
# include "rheolef/vec.h"
# include "rheolef/blas1-dense.h"

// =======================[ MAT-VEC PRODUCT ]====================================

namespace rheolef { 
// template <class Mat, class Vec> ??

class amux {
  public:
    typedef double element_type;
    typedef csr<double>::const_iterator  mat_const_iterator;
    typedef vec<double>::const_iterator  vec_const_iterator;
    class const_iterator {
      public:
        void operator++()       { ++ITER_A; }
        double operator* () const 
	{ 
	  return sxdoty ((*ITER_A).begin(), (*ITER_A).end(), X_VAL, double()); 
	}
	friend bool operator == (const_iterator i, const_iterator j)
	   { return i.ITER_A == j.ITER_A; }
        
	const_iterator (mat_const_iterator iter_a, vec_const_iterator x_val)
	 : ITER_A(iter_a), X_VAL(x_val) {}
      private:
        mat_const_iterator ITER_A;
        vec_const_iterator X_VAL;
    };
    const_iterator begin() const { return const_iterator(A_BEGIN, X.begin()); }
    const_iterator end()   const { return const_iterator(A_END, X.end()); }
    Index          size()  const { return N_ROW; }
    Index          n()     const { return N_ROW; }

    amux (const csr<double>& a, const vec<double>& x)
	  : A_BEGIN(a.begin()), A_END(a.end()), X(x), N_ROW(a.nrow())
	  { trace_expr_macro(" cstor amux"); }
    amux (const amux& e)
	  : A_BEGIN(e.A_BEGIN), A_END(e.A_END), X(e.X), N_ROW(e.N_ROW)
	  { trace_expr_macro(" copy  amux"); }
    ~amux ()
	  { trace_expr_macro(" dstor amux"); }
  private:
    // shallow copy for x: x = a*x; requires a double copy of x on rhs !
    vec<double>           X;
    mat_const_iterator    A_BEGIN;
    mat_const_iterator    A_END;
    Index                 N_ROW;
};
template<class T2>
inline
VExpr<amux>
operator * (const csr<double>& a, const vec<T2>& x)
{
    check_amulx_length (a, x);                 
    return VExpr<amux>(amux(a, x));
}
template<class X>
inline VExpr<amux>
operator * (const csr<double>& a, const VExpr<X>& x)
{
    vec<double> tmp = x;
    check_amulx_length (a, tmp);                 
    return VExpr<amux>(amux(a, tmp));
}
}// namespace rheolef
#endif // _SKIT_BLAS2_TMPL_H
