# rkt trust

Before executing a remotely fetched ACI, rkt will verify it based on attached signatures generated by the ACI creator.

Before this can happen, rkt needs to know which creators you trust, and therefore are trusted to run images on your machine.
The identity of each ACI creator is established with a public key, which is placed in rkt's key store on disk.

When adding a trusted key, a prefix can scope the level of established trust to a subset of images.
A few examples:

```
# rkt trust --prefix=storage.coreos.com
```

```
# rkt trust --prefix=coreos.com/etcd
```

To trust a key for an entire root domain, you must use the `--root` flag, with a path to a key file (no discovery).

```
# rkt trust --root ~/aci-pubkeys.gpg
```

## Trust a Key Using Meta Discovery

The easiest way to trust a key is through meta discovery.
rkt will find and download a public key that the creator has published on their website.
The [ACI discovery mechanism is detailed in the App Container specification][appc-discovery].
The TL;DR is rkt will find a meta tag that looks like:

```html
<meta name="ac-discovery-pubkeys" content="coreos.com/etcd https://coreos.com/dist/pubkeys/aci-pubkeys.gpg">
```

And use it to download the public key and present it to you for approval:

```
# rkt trust --prefix=coreos.com/etcd
Prefix: "coreos.com/etcd"
Key: "https://coreos.com/dist/pubkeys/aci-pubkeys.gpg"
GPG key fingerprint is: 8B86 DE38 890D DB72 9186  7B02 5210 BD88 8818 2190
  CoreOS ACI Builder <release@coreos.com>
Are you sure you want to trust this key (yes/no)? yes
Trusting "https://coreos.com/dist/pubkeys/aci-pubkeys.gpg" for prefix "coreos.com/etcd".
Added key for prefix "coreos.com/etcd" at "/etc/rkt/trustedkeys/prefix.d/coreos.com/etcd/8b86de38890ddb7291867b025210bd8888182190"
```

If rkt can't find a key using meta discovery, an error will be printed:

```
# rkt trust --prefix=coreos.com
Error determining key location: --prefix meta discovery error: found no ACI meta tags
```

## Trust a Key From Specific Location

If you know where a public key is located, you can request it directly from disk or via HTTPS:

```
# rkt trust --prefix=coreos.com/etcd https://coreos.com/dist/pubkeys/aci-pubkeys.gpg
Prefix: "coreos.com/etcd"
Key: "https://coreos.com/dist/pubkeys/aci-pubkeys.gpg"
GPG key fingerprint is: 8B86 DE38 890D DB72 9186  7B02 5210 BD88 8818 2190
  CoreOS ACI Builder <release@coreos.com>
Are you sure you want to trust this key (yes/no)? yes
Trusting "https://coreos.com/dist/pubkeys/aci-pubkeys.gpg" for prefix "coreos.com/etcd".
Added key for prefix "coreos.com/etcd" at "/etc/rkt/trustedkeys/prefix.d/coreos.com/etcd/8b86de38890ddb7291867b025210bd8888182190"
```

## Pre-Populating Trusted Keys on Disk

Trusted public keys can be pre-populated by placing them in the appropriate location on disk for the desired prefix.

```
$ find /etc/rkt/trustedkeys/
/etc/rkt/trustedkeys/
/etc/rkt/trustedkeys/prefix.d
/etc/rkt/trustedkeys/prefix.d/coreos.com
/etc/rkt/trustedkeys/prefix.d/coreos.com/etcd
/etc/rkt/trustedkeys/prefix.d/coreos.com/etcd/8b86de38890ddb7291867b025210bd8888182190
/etc/rkt/trustedkeys/root.d
/etc/rkt/trustedkeys/root.d/d8685c1eff3b2276e5da37fd65eea12767432ac4
```

## Options

| Flag | Default | Options | Description |
| --- | --- | --- | --- |
| `--insecure-allow-http` |  `false` | `true` or `false` | Allow HTTP use for key discovery and/or retrieval |
| `--prefix` |  `` | A URL prefix | Prefix to limit trust to |
| `--root` |  `false` | `true` or `false` | Add root key from filesystem without a prefix |
| `--skip-fingerprint-review` |  `false` | `true` or `false` | Accept key without fingerprint confirmation |

## Global options

See the table with [global options in general commands documentation][global-options].


[appc-discovery]: https://github.com/appc/spec/blob/master/spec/discovery.md
[global-options]: ../commands.md#global-options
