//driver.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2014
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#ifndef _LIBROAREIO_DRIVER_H_
#define _LIBROAREIO_DRIVER_H_

#include <roaraudio.h>

struct roar_cdriver {
 const char * name;
 int  (*open)(struct roar_vio_calls * calls, const char * name, const char * dev, struct roar_audio_info * info, int dir);
};

int roar_cdriver_open(struct roar_vio_calls * calls, const char * name, const char * dev, struct roar_audio_info * info, int dir);

int roar_cdriver_open2(struct roar_vio_calls * calls, const char * name, const char * dev, struct roar_audio_info * info, int dir, struct roar_keyval * para, ssize_t paralen);

ssize_t roar_cdriver_list   (const char ** list, size_t len, size_t offset) _LIBROAR_STREAM_STDATTRS;

// driver prototypes:
int roar_cdriver_oss (struct roar_vio_calls * calls, const char * name, const char * dev, struct roar_audio_info * info, int dir);
int roar_cdriver_roar(struct roar_vio_calls * calls, const char * name, const char * dev, struct roar_audio_info * info, int dir);

#endif

//ll
